/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.PlainJWT;
import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl.AbstractOIDCAuthenticationRequestMessageHandler;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public class BuildPlainRequestObjectJWT
extends AbstractOIDCAuthenticationRequestMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BuildPlainRequestObjectJWT.class);

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        ClaimsSet requestObjectClaims = this.getAuthenticationRequest().getRequestObjectClaimsSet();
        if (requestObjectClaims == null) {
            this.log.trace("{} RequestObject claims are not present, request object JWT skipped", (Object)this.getLogPrefix());
            return;
        }
        try {
            this.getAuthenticationRequest().setRequestObject((JWT)new PlainJWT(requestObjectClaims.toJWTClaimsSet()));
            this.log.trace("{} Built Plain JWT RequestObject from claims", (Object)this.getLogPrefix());
        }
        catch (ParseException e) {
            throw new MessageHandlerException("Unable to generate request object JWT", (Exception)((Object)e));
        }
    }
}

