/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl;

import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.ResponseType;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl.AbstractOIDCAuthenticationRequestActionMessageHandler;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public class AddResponseTypeAndModeHandler
extends AbstractOIDCAuthenticationRequestActionMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddResponseTypeAndModeHandler.class);

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        String responseTypeFromProfile = this.getProfileConfiguration().getResponseType(this.lookupProfileRequestContext(messageContext));
        ResponseType responseType = this.parseResponseType(responseTypeFromProfile);
        if (responseType == null) {
            throw new MessageHandlerException("response_type '" + responseTypeFromProfile + "' is not supported");
        }
        this.checkProviderSupportsResponseType(responseType);
        String responseModeFromProfile = this.getProfileConfiguration().getResponseMode(this.lookupProfileRequestContext(messageContext));
        ResponseMode responseModeOverride = this.parseResponseMode(responseModeFromProfile);
        this.log.trace("{} response mode override from profile config '{}', parsed as '{}'", new Object[]{this.getLogPrefix(), responseModeFromProfile, responseModeOverride});
        ResponseMode compatibleMode = ResponseMode.resolve(null, (ResponseType)responseType);
        if (compatibleMode == null) {
            throw new MessageHandlerException("A compatible response_mode for response_type '" + String.valueOf(responseType) + "' could not be found");
        }
        this.checkProviderSupportsResponseMode(compatibleMode);
        this.log.trace("{} Compatible response_mode '{}' resolved from response_type '{}'", new Object[]{this.getLogPrefix(), compatibleMode, responseTypeFromProfile});
        this.getAuthenticationRequest().setDefaultResponseMode(compatibleMode);
        if (responseModeOverride != null && !responseModeOverride.equals((Object)compatibleMode)) {
            this.log.debug("{} response_mode override '{}' exists in the profile configuration and is different than the default mode '{}' for response_type '{}'", new Object[]{this.getLogPrefix(), responseModeFromProfile, compatibleMode, responseType});
            this.checkProviderSupportsResponseMode(responseModeOverride);
            this.getAuthenticationRequest().setResponseMode(responseModeOverride);
        } else {
            this.getAuthenticationRequest().setResponseMode(compatibleMode);
        }
        this.getAuthenticationRequest().setResponseType(responseType);
        this.log.trace("{} response_type '{}' selected", (Object)this.getLogPrefix(), (Object)this.getAuthenticationRequest().getResponseType());
        this.log.trace("{} response_mode '{}' selected", (Object)this.getLogPrefix(), (Object)this.getAuthenticationRequest().getResponseMode());
    }

    private void checkProviderSupportsResponseType(@Nonnull ResponseType responseType) throws MessageHandlerException {
        List responseTypesSupported = this.getProviderMetadata().getResponseTypes();
        if (responseTypesSupported == null) {
            throw new MessageHandlerException("OpenID Provider has not specified supported response types (response_types_supported). It MUST.");
        }
        if (!responseTypesSupported.contains(responseType)) {
            throw new MessageHandlerException("OpenID Provider does not support chosen response_type: " + responseType.toString());
        }
    }

    private void checkProviderSupportsResponseMode(@Nonnull ResponseMode responseMode) throws MessageHandlerException {
        List responseModesSupportedOP = this.getProviderMetadata().getResponseModes();
        ArrayList<ResponseMode> responseModesSupported = new ArrayList<ResponseMode>(2);
        if (responseModesSupportedOP == null || responseModesSupportedOP.isEmpty()) {
            responseModesSupported.add(ResponseMode.QUERY);
            responseModesSupported.add(ResponseMode.FRAGMENT);
        } else {
            responseModesSupportedOP.forEach(responseModesSupported::add);
        }
        if (!responseModesSupported.contains(responseMode)) {
            throw new MessageHandlerException("OpenID Provider does not support chosen response_mode: " + responseMode.toString());
        }
    }

    @Nullable
    private ResponseType parseResponseType(@Nullable String responseTypeFromProfile) {
        if (responseTypeFromProfile == null) {
            return null;
        }
        if (responseTypeFromProfile.equals(ResponseType.CODE.toString())) {
            return ResponseType.CODE;
        }
        if (responseTypeFromProfile.equals(ResponseType.CODE_IDTOKEN.toString())) {
            return ResponseType.CODE_IDTOKEN;
        }
        if (responseTypeFromProfile.equals(ResponseType.CODE_IDTOKEN_TOKEN.toString())) {
            return ResponseType.CODE_IDTOKEN_TOKEN;
        }
        if (responseTypeFromProfile.equals(ResponseType.CODE_TOKEN.toString())) {
            return ResponseType.CODE_TOKEN;
        }
        if (responseTypeFromProfile.equals(ResponseType.IDTOKEN.toString())) {
            return ResponseType.IDTOKEN;
        }
        if (responseTypeFromProfile.equals(ResponseType.IDTOKEN_TOKEN.toString())) {
            return ResponseType.IDTOKEN_TOKEN;
        }
        return null;
    }

    @Nullable
    private ResponseMode parseResponseMode(@Nullable String responseModeFromProfile) {
        if (responseModeFromProfile == null) {
            return null;
        }
        if (responseModeFromProfile.equals(ResponseMode.FORM_POST.getValue())) {
            return ResponseMode.FORM_POST;
        }
        if (responseModeFromProfile.equals(ResponseMode.FORM_POST_JWT.getValue())) {
            return ResponseMode.FORM_POST_JWT;
        }
        if (responseModeFromProfile.equals(ResponseMode.QUERY.getValue())) {
            return ResponseMode.QUERY;
        }
        if (responseModeFromProfile.equals(ResponseMode.FRAGMENT.getValue())) {
            return ResponseMode.FRAGMENT;
        }
        if (responseModeFromProfile.equals(ResponseMode.FRAGMENT_JWT.getValue())) {
            return ResponseMode.FRAGMENT_JWT;
        }
        if (responseModeFromProfile.equals(ResponseMode.JWT.getValue())) {
            return ResponseMode.JWT;
        }
        if (responseModeFromProfile.equals(ResponseMode.QUERY_JWT.getValue())) {
            return ResponseMode.QUERY_JWT;
        }
        return null;
    }
}

