/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl;

import jakarta.servlet.http.HttpServletRequest;
import java.net.URI;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl.AbstractOIDCAuthenticationRequestActionMessageHandler;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddRedirectURIHandler
extends AbstractOIDCAuthenticationRequestActionMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddRedirectURIHandler.class);
    @NonnullAfterInit
    private BiFunction<HttpServletRequest, ProfileRequestContext, URI> redirectUriCreationStrategy;

    public void setRedirectUriCreationStrategy(@Nullable BiFunction<HttpServletRequest, ProfileRequestContext, URI> strategy) {
        this.checkSetterPreconditions();
        if (strategy != null) {
            this.redirectUriCreationStrategy = (BiFunction)Constraint.isNotNull(strategy, (String)"RedirectURI creation lookup strategy cannot be null");
        }
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.redirectUriCreationStrategy == null) {
            throw new ComponentInitializationException("redirectUriCreationStrategy cannot be null");
        }
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        URI redirectUri = this.redirectUriCreationStrategy.apply(this.getHttpServletRequest(), this.lookupProfileRequestContext(messageContext));
        if (redirectUri == null) {
            throw new MessageHandlerException("Redirect URI could not be located or created using the strategy");
        }
        this.log.trace("{} Created redirect_uri '{}'", (Object)this.getLogPrefix(), (Object)redirectUri);
        this.getAuthenticationRequest().setRedirectURI(redirectUri);
    }
}

