/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl.AbstractOIDCAuthenticationRequestActionMessageHandler;
import net.shibboleth.oidc.profile.core.OAuthAuthorizationRequest;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.codec.Base64Support;
import net.shibboleth.shared.codec.EncodingException;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public class AddPCKECodeVerifierAndChallenge
extends AbstractOIDCAuthenticationRequestActionMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddPCKECodeVerifierAndChallenge.class);

    protected void doInvoke(MessageContext messageContext) throws MessageHandlerException {
        if (this.getProfileConfiguration().isForcePKCE(this.lookupProfileRequestContext(messageContext))) {
            this.log.trace("{} PKCE enabled, adding code_challenge to request", (Object)this.getLogPrefix());
            OAuthAuthorizationRequest.CodeChallengeMethod method = this.getProfileConfiguration().isAllowPKCEPlain(this.lookupProfileRequestContext(messageContext)) ? OAuthAuthorizationRequest.CodeChallengeMethod.PLAIN : OAuthAuthorizationRequest.CodeChallengeMethod.S256;
            String codeVerifier = AddPCKECodeVerifierAndChallenge.generateCodeVerifier(32);
            String challenge = this.computeCodeChallenge(codeVerifier, method);
            if (this.log.isTraceEnabled()) {
                this.log.trace("{} Created code verifier '...{}'", (Object)this.getLogPrefix(), (Object)codeVerifier.substring(challenge.length() - 3));
                this.log.trace("{} Derived code challenge '...{}'", (Object)this.getLogPrefix(), (Object)challenge.substring(challenge.length() - 3));
            }
            this.getAuthenticationRequest().setCodeVerifier(codeVerifier);
            this.getAuthenticationRequest().setCodeChallenge(challenge);
            this.getAuthenticationRequest().setCodeChallengeMethod(method);
        } else {
            this.log.trace("{} PKCE not enabled", (Object)this.getLogPrefix());
        }
    }

    @Nonnull
    private static String generateCodeVerifier(@Nonnull Integer length) throws MessageHandlerException {
        if (length < 32) {
            throw new MessageHandlerException("PKCE coder_verifier must be at least 32 bytes long");
        }
        try {
            SecureRandom secureRandom = new SecureRandom();
            byte[] verifierInBytes = new byte[length.intValue()];
            secureRandom.nextBytes(verifierInBytes);
            return Base64Support.encodeURLSafe((byte[])verifierInBytes);
        }
        catch (Exception e) {
            throw new MessageHandlerException(e);
        }
    }

    @Nonnull
    @NotEmpty
    private String computeCodeChallenge(@Nonnull @NotEmpty String codeVerifier, @Nonnull OAuthAuthorizationRequest.CodeChallengeMethod method) throws MessageHandlerException {
        if (method == OAuthAuthorizationRequest.CodeChallengeMethod.PLAIN) {
            return codeVerifier;
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-256");
            byte[] hash = md.digest(codeVerifier.getBytes());
            assert (hash != null);
            return Base64Support.encodeURLSafe((byte[])hash);
        }
        catch (NoSuchAlgorithmException | EncodingException e) {
            throw new MessageHandlerException("Unable to compute code_challenge", (Exception)e);
        }
    }
}

