/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl;

import java.net.URI;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl.AbstractOIDCAuthenticationRequestActionMessageHandler;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public class AddEndpointURIHandler
extends AbstractOIDCAuthenticationRequestActionMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddEndpointURIHandler.class);

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        URI authzEndpoint = this.getProviderMetadata().getAuthorizationEndpointURI();
        if (authzEndpoint == null) {
            throw new MessageHandlerException("OAuth 2.0 Authorization Endpoint URI not found in provider metadata");
        }
        this.getAuthenticationRequest().setEndpointURI(authzEndpoint);
        this.log.trace("{} Added authorization endpoint '{}' to authentication request", (Object)this.getLogPrefix(), (Object)this.getAuthenticationRequest().getEndpointURI());
    }
}

