/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl;

import com.nimbusds.openid.connect.sdk.claims.ACR;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl.AbstractOIDCAuthenticationRequestActionMessageHandler;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddAuthenticationContextClassReferencesHandler
extends AbstractOIDCAuthenticationRequestActionMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddAuthenticationContextClassReferencesHandler.class);

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        List<ACR> acrs = this.buildRequestedAuthnContext(this.lookupProfileRequestContext(messageContext));
        if (acrs != null) {
            this.log.trace("{} setting ACRs to '{}' ", (Object)this.getLogPrefix(), acrs);
            this.getAuthenticationRequest().setAcrs(acrs);
        } else {
            this.log.trace("{} no ACRs requested", (Object)this.getLogPrefix());
        }
    }

    @Nullable
    private List<ACR> buildRequestedAuthnContext(@Nullable ProfileRequestContext profileRequestContext) {
        List principals = this.getProfileConfiguration().getDefaultAuthenticationMethods(profileRequestContext);
        if (principals.isEmpty()) {
            return null;
        }
        return principals.stream().map(p -> new ACR(p.getName())).toList();
    }
}

