/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.function.Consumer;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.oidc.rp.exception.OIDCRPException;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.jwt.claims.ClaimsValidator;
import net.shibboleth.oidc.jwt.claims.JWTValidationException;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateTokenClaims
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateTokenClaims.class);
    @Nullable
    private Consumer<ProfileRequestContext> cleanupHook;
    @NonnullBeforeExec
    private JWTClaimsSet claimsSet;
    @NonnullAfterInit
    private ClaimsValidator claimsValidator;
    @NonnullAfterInit
    private Function<ProfileRequestContext, JWT> jwtLookupStrategy;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.claimsValidator == null) {
            throw new ComponentInitializationException("JWT ClaimSet Validator cannot be null");
        }
        if (this.jwtLookupStrategy == null) {
            throw new ComponentInitializationException("JWT lookup strategy cannot be null");
        }
    }

    public void setJwtLookupStrategy(@Nonnull Function<ProfileRequestContext, JWT> strategy) {
        this.checkSetterPreconditions();
        this.jwtLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)" JWT lookup strategy can not be null");
    }

    public void setCleanupHook(@Nullable Consumer<ProfileRequestContext> hook) {
        this.checkSetterPreconditions();
        this.cleanupHook = hook;
    }

    public void setClaimsValidator(@Nonnull ClaimsValidator validator) {
        this.checkSetterPreconditions();
        this.claimsValidator = (ClaimsValidator)Constraint.isNotNull((Object)validator, (String)"Claims validator cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        JWT token = this.jwtLookupStrategy.apply(profileRequestContext);
        if (token == null) {
            this.log.error("{} JWT was not located, nothing to validate", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        try {
            this.claimsSet = token.getJWTClaimsSet();
            if (this.claimsSet == null) {
                throw new OIDCRPException("JWT ClaimsSet is null");
            }
        }
        catch (ParseException | OIDCRPException e) {
            this.log.error("{} JWT Claimset is not available", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        String subject = this.claimsSet.getSubject() != null ? this.claimsSet.getSubject() : "unknown subject";
        this.log.debug("{} Validating JWT claims for subject '{}'", (Object)this.getLogPrefix(), (Object)subject);
        try {
            this.claimsValidator.validate(this.claimsSet, profileRequestContext);
            if (this.cleanupHook != null) {
                this.cleanupHook.accept(profileRequestContext);
            }
        }
        catch (JWTValidationException e) {
            this.log.error("{} JWT claims verification failed for subject '{}'", new Object[]{this.getLogPrefix(), subject, e});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidToken");
            if (this.cleanupHook != null) {
                this.cleanupHook.accept(profileRequestContext);
            }
            return;
        }
        this.log.debug("{} JWT claims are valid for subject '{}'", (Object)this.getLogPrefix(), (Object)this.claimsSet.getSubject());
    }
}

