/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.openid.connect.sdk.AuthenticationErrorResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationResponse;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateAuthenticationResponseResult
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateAuthenticationResponseResult.class);
    @NonnullBeforeExec
    private AuthenticationResponse authenticationResponse;

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        AuthenticationResponse response;
        MessageContext inMsgContext = profileRequestContext.getInboundMessageContext();
        if (inMsgContext == null) {
            this.log.debug("{} Inbound message context was null", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        Object object = inMsgContext.getMessage();
        if (!(object instanceof AuthenticationResponse)) {
            this.log.debug("{} Inbound message was not an authentication response", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.authenticationResponse = response = (AuthenticationResponse)object;
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!this.authenticationResponse.indicatesSuccess()) {
            AuthenticationErrorResponse error = this.authenticationResponse.toErrorResponse();
            assert (error != null);
            if (this.log.isErrorEnabled()) {
                this.log.error("{} OIDC Authentication Response contained an error from upstream OP '{}' : {}", new Object[]{this.getLogPrefix(), authenticationContext.getAuthenticatingAuthority(), this.buildErrorResponseString(error)});
            }
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"MessageProcessingError");
        } else {
            this.log.debug("{} Upstream OP signalled a successful response", (Object)this.getLogPrefix());
        }
    }

    private String buildErrorResponseString(@Nonnull AuthenticationErrorResponse error) {
        StringBuilder builder = new StringBuilder();
        if (error.getErrorObject() != null) {
            builder.append("Code -> '").append(error.getErrorObject().getCode()).append("'");
            builder.append(", ");
            builder.append("Description -> '").append(error.getErrorObject().getDescription()).append("'");
        } else {
            builder.append("Unknown error response");
        }
        return builder.toString();
    }
}

