/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AbstractAuthenticatableOIDCContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.UserInfoResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.exception.OIDCRPException;
import net.shibboleth.idp.plugin.authn.oidc.rp.impl.AbstractHttpOIDCAuthenticationAction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class UserInfoEndpointLookup
extends AbstractHttpOIDCAuthenticationAction<UserInfoResponse> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(UserInfoEndpointLookup.class);
    @Nonnull
    private Function<ProfileRequestContext, UserInfoResponseContext> userInfoResponseContextLookupStrategy = new ChildContextLookup(UserInfoResponseContext.class, true).compose((Function)new InboundMessageContextLookup());

    public void setUserInfoResponseContextLookupStrategy(@Nonnull Function<ProfileRequestContext, UserInfoResponseContext> strategy) {
        this.checkSetterPreconditions();
        this.userInfoResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"UserInfoResponseContext lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        this.log.debug("{} Requesting claims from UserInfo endpoint from provider '{}'", (Object)this.getLogPrefix(), (Object)authenticationContext.getAuthenticatingAuthority());
        UserInfoResponseContext userInfoCtx = this.userInfoResponseContextLookupStrategy.apply(profileRequestContext);
        if (userInfoCtx == null) {
            this.log.debug("{} No UserInfo response context returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        try {
            UserInfoResponse response = (UserInfoResponse)this.handleRequest(profileRequestContext, (AbstractAuthenticatableOIDCContext)userInfoCtx);
            if (response.indicatesSuccess()) {
                userInfoCtx.setUserInfo(response.toSuccessResponse());
            }
        }
        catch (OIDCRPException e) {
            this.log.error("{} Unable to return claims from UserInfo endpoint", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidUserInfoClaims");
        }
    }
}

