/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.security.auth.Subject;
import net.shibboleth.idp.authn.AbstractSubjectCanonicalizationAction;
import net.shibboleth.idp.authn.SubjectCanonicalizationException;
import net.shibboleth.idp.authn.context.SubjectCanonicalizationContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.principal.OIDCSubjectIdentifierPrincipal;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class SimpleOIDCSubjectIdentifierCanonicalization
extends AbstractSubjectCanonicalizationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SimpleOIDCSubjectIdentifierCanonicalization.class);
    @Nonnull
    private final ActivationCondition embeddedPredicate = new ActivationCondition(false);
    @Nullable
    private OIDCSubjectIdentifierPrincipal subjectIdentifierPrincipal;

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        if (this.embeddedPredicate.apply(profileRequestContext, c14nContext, true)) {
            Subject c14CtxSubject = c14nContext.getSubject();
            assert (c14CtxSubject != null);
            this.subjectIdentifierPrincipal = c14CtxSubject.getPrincipals(OIDCSubjectIdentifierPrincipal.class).iterator().next();
            return super.doPreExecute(profileRequestContext, c14nContext);
        }
        return false;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext) {
        assert (this.subjectIdentifierPrincipal != null);
        c14nContext.setPrincipalName(this.applyTransforms(this.subjectIdentifierPrincipal.getName()));
    }

    public static class ActivationCondition
    implements Predicate<ProfileRequestContext> {
        @Nonnull
        private final Logger log = LoggerFactory.getLogger(ActivationCondition.class);
        private final boolean disabled;

        public ActivationCondition(@ParameterName(name="disabled") boolean disable) {
            this.disabled = disable;
        }

        @Override
        public boolean test(@Nullable ProfileRequestContext input) {
            SubjectCanonicalizationContext c14nContext;
            if (this.disabled) {
                this.log.trace("SimpleOIDCSubjectIdentifierCanonicalization has been disabled by configuration");
                return false;
            }
            if (input != null && (c14nContext = (SubjectCanonicalizationContext)input.getSubcontext(SubjectCanonicalizationContext.class)) != null) {
                boolean shouldRun = this.apply(input, c14nContext, false);
                this.log.trace("SimpleOIDCSubjectIdentifierCanonicalization is {} for the given context", (Object)(shouldRun ? "active" : "not active"));
                return shouldRun;
            }
            this.log.trace("SimpleOIDCSubjectIdentifierCanonicalization is not active for the given context");
            return false;
        }

        public boolean apply(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull SubjectCanonicalizationContext c14nContext, boolean duringAction) {
            Subject c14CtxSubject = c14nContext.getSubject();
            Set<OIDCSubjectIdentifierPrincipal> subjects = c14CtxSubject != null ? c14CtxSubject.getPrincipals(OIDCSubjectIdentifierPrincipal.class) : null;
            if (subjects == null || subjects.isEmpty()) {
                c14nContext.setException((Exception)new SubjectCanonicalizationException("No OIDCSubjectIdentifierPrincipals were found"));
                if (duringAction) {
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
                }
                return false;
            }
            if (subjects.size() > 1) {
                c14nContext.setException((Exception)new SubjectCanonicalizationException("Multiple OIDCSubjectIdentifierPrincipals were found"));
                if (duringAction) {
                    ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidSubject");
                }
                return false;
            }
            return true;
        }
    }
}

