/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.text.ParseException;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AccessTokenResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.EndUserClaimsContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.UserInfoResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.impl.DefaultClaimMergingStrategy;
import net.shibboleth.idp.plugin.authn.oidc.rp.impl.DefaultClaimSanitizationStrategy;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class ProcessEndUserClaims
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ProcessEndUserClaims.class);
    @Nonnull
    private Function<ProfileRequestContext, UserInfoResponseContext> userInfoResponseContextLookupStrategy = new ChildContextLookup(UserInfoResponseContext.class).compose((Function)new InboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, AccessTokenResponseContext> accessTokenResponseContextLookupStrategy = new ChildContextLookup(AccessTokenResponseContext.class).compose((Function)new InboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, EndUserClaimsContext> endUserClaimsContextLookupStrategy = new ChildContextLookup(EndUserClaimsContext.class, true).compose((Function)new InboundMessageContextLookup());
    @Nonnull
    private BinaryOperator<ClaimsSet> claimMergingStrategy = new DefaultClaimMergingStrategy();
    @Nonnull
    private UnaryOperator<ClaimsSet> claimSanitizationStrategy = new DefaultClaimSanitizationStrategy();
    @NonnullBeforeExec
    private ClaimsSet userInfoClaims;
    @NonnullBeforeExec
    private JWTClaimsSet idTokenClaims;

    public void setClaimMergingStrategy(@Nonnull BinaryOperator<ClaimsSet> strategy) {
        this.checkSetterPreconditions();
        this.claimMergingStrategy = (BinaryOperator)Constraint.isNotNull(strategy, (String)"ClaimMergingStrategy cannot be null");
    }

    public void setClaimSanitizationStrategy(@Nonnull UnaryOperator<ClaimsSet> strategy) {
        this.checkSetterPreconditions();
        this.claimSanitizationStrategy = (UnaryOperator)Constraint.isNotNull(strategy, (String)"ClaimSanatizationStrategy cannot be null");
    }

    public void setEnableClaimSanitizationStrategy(boolean enable) {
        if (!enable) {
            this.claimSanitizationStrategy = c -> {
                ClaimsSet claims = new ClaimsSet();
                claims.putAll(c);
                return claims;
            };
        }
    }

    public void setEndUserClaimsContextLookupStrategy(@Nonnull Function<ProfileRequestContext, EndUserClaimsContext> strategy) {
        this.checkSetterPreconditions();
        this.endUserClaimsContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"EndUserClaimsContextLookupStrategy cannot be null");
    }

    public void setAccessTokenResponseContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AccessTokenResponseContext> strategy) {
        this.checkSetterPreconditions();
        this.accessTokenResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TokenResponseContext lookup strategy cannot be null");
    }

    public void setUserInfoResponseContextLookupStrategy(@Nonnull Function<ProfileRequestContext, UserInfoResponseContext> strategy) {
        this.checkSetterPreconditions();
        this.userInfoResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"UserInfoResponseContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        OIDCTokenResponse tokenResponse;
        UserInfoSuccessResponse userInfo;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        UserInfoResponseContext userInfoCtx = this.userInfoResponseContextLookupStrategy.apply(profileRequestContext);
        UserInfoSuccessResponse userInfoSuccessResponse = userInfo = userInfoCtx != null ? userInfoCtx.getUserInfo() : null;
        if (userInfoCtx == null || userInfo == null) {
            this.log.trace("{} No UserInfo response context returned by lookup strategy, creating empty UserInfo claims", (Object)this.getLogPrefix());
            this.userInfoClaims = new ClaimsSet();
        } else if (userInfo.getEntityContentType() == ContentType.APPLICATION_JSON) {
            this.userInfoClaims = userInfo.getUserInfo();
        } else if (userInfo.getEntityContentType() == ContentType.APPLICATION_JWT) {
            try {
                ClaimsSet claims = new ClaimsSet();
                claims.putAll(userInfo.getUserInfoJWT().getJWTClaimsSet().getClaims());
                this.userInfoClaims = claims;
            }
            catch (ParseException e) {
                this.log.warn("Unable to extract UserInfo claims from JWT claimsset", (Throwable)e);
                return false;
            }
        } else {
            this.log.warn("Unable to extract UserInfo claims, unknown entity content type");
            return false;
        }
        AccessTokenResponseContext tokenResponseCtx = this.accessTokenResponseContextLookupStrategy.apply(profileRequestContext);
        OIDCTokenResponse oIDCTokenResponse = tokenResponse = tokenResponseCtx != null ? tokenResponseCtx.getTokenResponse() : null;
        if (tokenResponseCtx == null || tokenResponse == null) {
            this.log.debug("{} No AccessTokenResponseContext or Access Token returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        if (tokenResponse.getOIDCTokens() == null || tokenResponse.getOIDCTokens().getIDToken() == null) {
            this.log.debug("{} AccessTokenResponseContext did not contain an id_token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        try {
            this.idTokenClaims = tokenResponse.getOIDCTokens().getIDToken().getJWTClaimsSet();
            if (this.idTokenClaims == null) {
                this.log.debug("{} AccessTokenResponseContext did not contain an id_token with accessible claims, possibly still encrypted", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                return false;
            }
        }
        catch (ParseException e) {
            this.log.debug("{} Unable to parse claims from id_token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (this.log.isTraceEnabled()) {
            this.log.trace("{} Processing {} claims", (Object)this.getLogPrefix(), (Object)(this.userInfoClaims.toJSONObject().size() > 0 ? "UserInfo and ID Token" : "ID Token"));
        }
        ClaimsSet idToken = new ClaimsSet();
        idToken.putAll(this.idTokenClaims.toJSONObject());
        ClaimsSet sanitizedUserInfoClaims = (ClaimsSet)this.claimSanitizationStrategy.apply(this.userInfoClaims);
        ClaimsSet sanitizedIdTokenClaims = (ClaimsSet)this.claimSanitizationStrategy.apply(idToken);
        ClaimsSet mergedClaims = (ClaimsSet)this.claimMergingStrategy.apply(sanitizedUserInfoClaims, sanitizedIdTokenClaims);
        JWTClaimsSet idTokenClaimsCopy = this.idTokenClaims;
        assert (idTokenClaimsCopy != null);
        this.endUserClaimsContextLookupStrategy.apply(profileRequestContext).setEndUserClaims(mergedClaims != null ? mergedClaims : new ClaimsSet()).setUnprocessedIdTokenClaims(idTokenClaimsCopy);
        if (this.log.isTraceEnabled() && mergedClaims != null) {
            this.log.trace("{} Merged and sanitized claims to produce the claims set '{}'", (Object)this.getLogPrefix(), (Object)mergedClaims.toJSONString());
        }
    }
}

