/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import java.security.SecureRandom;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.oidc.rp.exception.OIDCProxyException;
import net.shibboleth.shared.logic.Constraint;
import org.apache.commons.codec.DecoderException;
import org.apache.commons.codec.binary.Hex;

public final class OIDCProxySupport {
    private OIDCProxySupport() {
    }

    @Nonnull
    public static String generateNonce(@Nonnull Integer length) {
        SecureRandom secureRandom = new SecureRandom();
        StringBuilder sb = new StringBuilder();
        while (sb.length() < length) {
            sb.append(Integer.toHexString(secureRandom.nextInt()));
        }
        String nonce = sb.toString().substring(0, length);
        assert (nonce != null);
        return nonce;
    }

    @Nonnull
    public static String generateState(@Nonnull String nonce, @Nonnull String key) {
        Constraint.isNotNull((Object)nonce, (String)"NonceHex key can not be null");
        Constraint.isNotNull((Object)key, (String)"Webflow execution key can not be null");
        String keyHex = Hex.encodeHexString((byte[])key.getBytes());
        return nonce + "." + keyHex;
    }

    @Nonnull
    public static String extractKeyFromState(@Nonnull String state) throws OIDCProxyException {
        Constraint.isNotNull((Object)state, (String)"State can not be null");
        String[] stateSplit = state.split("\\.");
        if (stateSplit.length != 2) {
            throw new OIDCProxyException("State does not contain the key component");
        }
        String hexKey = stateSplit[1];
        try {
            return new String(Hex.decodeHex((String)hexKey));
        }
        catch (DecoderException e) {
            throw new OIDCProxyException("Can not hex decode key", (Throwable)e);
        }
    }

    @Nonnull
    public static String extractNonceFromState(@Nonnull String state) throws OIDCProxyException {
        Constraint.isNotNull((Object)state, (String)"State can not be null");
        String[] stateSplit = state.split("\\.");
        if (stateSplit.length != 2) {
            throw new OIDCProxyException("State does not contain the nonce component");
        }
        String foundState = stateSplit[0];
        if (foundState == null) {
            throw new OIDCProxyException("State does not contain the nonce component");
        }
        return foundState;
    }
}

