/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.context.OIDCProviderMetadataContext;
import net.shibboleth.oidc.profile.messaging.context.OIDCPeerEntityContext;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class InitializeRelyingPartyContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeRelyingPartyContext.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextCreationStrategy = new ChildContextLookup(RelyingPartyContext.class, true);
    @Nonnull
    private Function<ProfileRequestContext, OIDCProviderMetadataContext> oidcProviderMetadataContextLookupStrategy = new ChildContextLookup(OIDCProviderMetadataContext.class).compose(new ChildContextLookup(OIDCPeerEntityContext.class).compose((Function)new InboundMessageContextLookup()));
    @NonnullBeforeExec
    private OIDCPeerEntityContext peerEntityCtx;
    @Nonnull
    private Function<ProfileRequestContext, OIDCPeerEntityContext> peerEntityContextLookupStrategy = new ChildContextLookup(OIDCPeerEntityContext.class).compose((Function)new InboundMessageContextLookup());
    @NonnullBeforeExec
    private String peerIdentifier;

    public void setPeerEntityContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCPeerEntityContext> strategy) {
        this.checkSetterPreconditions();
        this.peerEntityContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCPeerEntityContext lookup strategy cannot be null");
    }

    public void setRelyingPartyContextCreationStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextCreationStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext creation strategy cannot be null");
    }

    public void setOidcProviderMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCProviderMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.oidcProviderMetadataContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCMetadataContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            this.log.error("{} pre-execute failed", (Object)this.getLogPrefix());
            return false;
        }
        this.peerEntityCtx = this.peerEntityContextLookupStrategy.apply(profileRequestContext);
        if (this.peerEntityCtx == null) {
            this.log.warn("{} Unable to locate OIDCPeerEntityContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.peerIdentifier = this.peerEntityCtx.getIdentifier();
        if (this.peerIdentifier == null) {
            this.log.warn("{} Unable to locate peer identifier", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        RelyingPartyContext rpContext = this.relyingPartyContextCreationStrategy.apply(profileRequestContext);
        if (rpContext == null) {
            this.log.error("{} Unable to locate or create RelyingPartyContext", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return;
        }
        this.log.debug("Attaching RelyingPartyContext for OP '{}'", (Object)this.peerEntityCtx.getIdentifier());
        rpContext.setRelyingPartyId(this.peerEntityCtx.getIdentifier());
        rpContext.setRelyingPartyIdContextTree((BaseContext)this.peerEntityCtx);
        OIDCProviderMetadataContext oidcContext = this.oidcProviderMetadataContextLookupStrategy.apply(profileRequestContext);
        if (oidcContext == null) {
            this.log.trace("{} Unable to find OpenID Provider Metadata", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return;
        }
        OIDCProviderMetadata providerMetadata = oidcContext.getProviderInformation();
        if (providerMetadata != null && this.peerIdentifier.equals(providerMetadata.getIssuer().getValue())) {
            this.log.debug("{} Setting the OP context to 'verified'", (Object)this.getLogPrefix());
            rpContext.setVerified(Boolean.valueOf(true));
        }
    }
}

