/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import java.net.URI;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.oidc.rp.config.navigate.RedirectUriLookupFunction;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.OAuth2ClientContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.profile.config.OIDCAuthenticationRelyingPartyProfileConfiguration;
import net.shibboleth.oidc.profile.messaging.context.OIDCPeerEntityContext;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public class InitializeOAuth2ClientContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeOAuth2ClientContext.class);
    @Nonnull
    private Function<ProfileRequestContext, OAuth2ClientContext> oauth2ClientContextLookupStrategy = new ChildContextLookup(OAuth2ClientContext.class, true).compose(new ChildContextLookup(OIDCPeerEntityContext.class).compose((Function)new OutboundMessageContextLookup()));
    @NonnullBeforeExec
    private OAuth2ClientContext oauth2ClientContext;
    @Nonnull
    private Function<ProfileRequestContext, URI> redirectUriOverrideLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @NonnullBeforeExec
    private OIDCAuthenticationRelyingPartyProfileConfiguration profileConfiguration;

    public InitializeOAuth2ClientContext() {
        this.redirectUriOverrideLookupStrategy = new RedirectUriLookupFunction();
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setRedirectUriOverrideLookupStrategy(@Nonnull Function<ProfileRequestContext, URI> strategy) {
        this.checkSetterPreconditions();
        this.redirectUriOverrideLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Redirect URI lookup strategy can not be null");
    }

    public void setOAuth2ClientContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OAuth2ClientContext> strgy) {
        this.checkSetterPreconditions();
        this.oauth2ClientContextLookupStrategy = (Function)Constraint.isNotNull(strgy, (String)"OAuth2 client context lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        ProfileConfiguration profileConfiguration;
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.oauth2ClientContext = this.oauth2ClientContextLookupStrategy.apply(profileRequestContext);
        if (this.oauth2ClientContext == null) {
            this.log.error("{} No OAuth2 client context found or created", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.apply(profileRequestContext);
        if (rpCtx != null && rpCtx.getConfiguration() != null && (profileConfiguration = rpCtx.getProfileConfig()) instanceof OIDCAuthenticationRelyingPartyProfileConfiguration) {
            OIDCAuthenticationRelyingPartyProfileConfiguration rpConfig;
            this.profileConfiguration = rpConfig = (OIDCAuthenticationRelyingPartyProfileConfiguration)profileConfiguration;
        }
        if (this.profileConfiguration == null) {
            this.log.error("{} OIDCAuthorizationConfiguration not found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        super.doExecute(profileRequestContext);
        String clientId = this.profileConfiguration.getClientId(profileRequestContext);
        if (StringSupport.trimOrNull((String)clientId) == null) {
            this.log.error("{} No client_id found from the profile configuration", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyConfiguration");
            return;
        }
        assert (clientId != null);
        this.oauth2ClientContext.setClientId(clientId);
        URI redirectUri = this.redirectUriOverrideLookupStrategy.apply(profileRequestContext);
        if (redirectUri != null) {
            this.log.debug("{} Redirect_uri has been explicitly set as '{}'", (Object)this.getLogPrefix(), (Object)redirectUri);
            this.oauth2ClientContext.setRedirectUriOverride(redirectUri);
        }
        this.log.debug("{} Initialized OAuth2 Client Context for client '{}'", (Object)this.getLogPrefix(), (Object)clientId);
    }
}

