/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.oauth2.sdk.id.ClientID;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.OAuth2ClientContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.oidc.profile.messaging.context.OIDCPeerEntityContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public class InitializeAuthorizationRequest
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeAuthorizationRequest.class);
    @Nonnull
    private Function<ProfileRequestContext, OAuth2ClientContext> oauth2ClientContextLookupStrategy = new ChildContextLookup(OAuth2ClientContext.class, true).compose(new ChildContextLookup(OIDCPeerEntityContext.class).compose((Function)new OutboundMessageContextLookup()));
    @NonnullBeforeExec
    private OAuth2ClientContext oauth2ClientContext;
    @NonnullBeforeExec
    private MessageContext outMessageContext;

    public void setOAuth2ClientContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OAuth2ClientContext> strgy) {
        this.checkSetterPreconditions();
        this.oauth2ClientContextLookupStrategy = (Function)Constraint.isNotNull(strgy, (String)"OAuth2 client context lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.oauth2ClientContext = this.oauth2ClientContextLookupStrategy.apply(profileRequestContext);
        if (this.oauth2ClientContext == null) {
            this.log.error("{} OAuth2 client context not found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        this.outMessageContext = profileRequestContext.getOutboundMessageContext();
        if (this.outMessageContext == null) {
            this.log.error("{} Outbound message context not found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileConfiguration");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        super.doExecute(profileRequestContext);
        OIDCAuthenticationRequest authRequest = new OIDCAuthenticationRequest(new ClientID(this.oauth2ClientContext.getClientId()));
        this.outMessageContext.setMessage((Object)authRequest);
        this.log.debug("{} Adding shell OIDC authentication request to outbound context for client '{}'", (Object)this.getLogPrefix(), (Object)this.oauth2ClientContext.getClientId());
    }
}

