/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.util.Map;
import java.util.Set;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.security.jwt.claims.impl.IDTokenClaims;
import net.shibboleth.oidc.security.jwt.claims.impl.JWTClaims;

public class DefaultClaimSanitizationStrategy
implements UnaryOperator<ClaimsSet> {
    @Nonnull
    private final Set<String> validationClaims;

    public DefaultClaimSanitizationStrategy() {
        Set<String> validationClaimsBuilt = Set.of(IDTokenClaims.AUTHORIZED_PARTY.getClaimName(), IDTokenClaims.NONCE.getClaimName(), IDTokenClaims.AUTHENTICATION_TIME.getClaimName(), IDTokenClaims.AUTHENTICATION_CONTEXT_CLASS_REFERENCE.getClaimName(), IDTokenClaims.AUTHENTICATION_METHODS_REFERENCES.getClaimName(), JWTClaims.ISSUER_CLAIM.getClaimName(), JWTClaims.ISSUED_AT_CLAIM.getClaimName(), JWTClaims.AUDIENCE_CLAIM.getClaimName(), JWTClaims.EXPIRATION_TIME_CLAIM.getClaimName(), "at_hash");
        assert (validationClaimsBuilt != null);
        this.validationClaims = validationClaimsBuilt;
    }

    @Override
    public ClaimsSet apply(@Nullable ClaimsSet jwtClaims) {
        if (jwtClaims == null) {
            return new ClaimsSet();
        }
        ClaimsSet sanitizedClaims = new ClaimsSet();
        Map<String, Object> filteredMap = jwtClaims.toJSONObject().entrySet().stream().filter(c -> c.getValue() != null).filter(c -> !this.validationClaims.contains(c.getKey())).filter(c -> c.getKey() != null).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        sanitizedClaims.putAll(filteredMap);
        return sanitizedClaims;
    }
}

