/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BinaryOperator;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minidev.json.JSONObject;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.slf4j.Logger;

public class DefaultClaimMergingStrategy
implements BinaryOperator<ClaimsSet> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultClaimMergingStrategy.class);

    @Override
    @Nonnull
    public ClaimsSet apply(@Nullable ClaimsSet userInfo, @Nullable ClaimsSet idToken) {
        if (userInfo == null && idToken != null) {
            ClaimsSet singleSet = new ClaimsSet();
            singleSet.putAll((Map)idToken.toJSONObject());
            return singleSet;
        }
        if (userInfo != null && idToken == null) {
            ClaimsSet singleSet = new ClaimsSet();
            singleSet.putAll((Map)userInfo.toJSONObject());
            return singleSet;
        }
        if (userInfo == null || idToken == null) {
            return new ClaimsSet();
        }
        JSONObject idTokenAsMap = idToken.toJSONObject();
        JSONObject userInfoClaimsAsMap = userInfo.toJSONObject();
        HashMap mergedClaimsMap = new HashMap(userInfoClaimsAsMap);
        idTokenAsMap.forEach((key, value) -> mergedClaimsMap.merge(key, value, (v1, v2) -> {
            this.log.trace("Claim '{}' exists in id_token and UserInfo response, taking id_token value '{}'", key, v2);
            return v2;
        }));
        ClaimsSet mergedClaimsSet = new ClaimsSet();
        mergedClaimsSet.putAll(mergedClaimsMap);
        return mergedClaimsSet;
    }
}

