/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.encoding.impl;

import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.authn.context.OAuth2ClientAuthenticationContext;
import net.shibboleth.oidc.metadata.context.OIDCProviderMetadataContext;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.oidc.profile.messaging.context.OIDCPeerEntityContext;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public abstract class AbstractRequestEncoderFunction
extends AbstractInitializableComponent
implements Function<ProfileRequestContext, ClassicHttpRequest> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractRequestEncoderFunction.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCProviderMetadataContext> providerMetadataLookupStrategy = new ChildContextLookup(OIDCProviderMetadataContext.class).compose(new ChildContextLookup(OIDCPeerEntityContext.class).compose((Function)new OutboundMessageContextLookup()));
    @Nonnull
    private Function<ProfileRequestContext, OAuth2ClientAuthenticationContext> oauth2ClientAuthenticationContextLookupStrategy = new ChildContextLookup(OAuth2ClientAuthenticationContext.class).compose(new ChildContextLookup(OIDCPeerEntityContext.class).compose((Function)new OutboundMessageContextLookup()));
    @Nullable
    private AuthenticationSuccessResponse authnResponse;
    @Nullable
    private OIDCAuthenticationRequest authnRequest;
    @Nullable
    private OIDCProviderMetadataContext providerMetadataContext;
    @Nullable
    private OAuth2ClientAuthenticationContext clientAuthnContext;

    protected AbstractRequestEncoderFunction() {
    }

    public void setOIDCClientAuthenticationContextContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OAuth2ClientAuthenticationContext> strgy) {
        this.checkSetterPreconditions();
        this.oauth2ClientAuthenticationContextLookupStrategy = (Function)Constraint.isNotNull(strgy, (String)"OAuth2 client context lookup strategy cannot be null");
    }

    public void setProviderMetadataLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCProviderMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.providerMetadataLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Provider metadata lookup strategy can not be null");
    }

    @Nullable
    protected AuthenticationSuccessResponse getAuthenticationResponse() {
        return this.authnResponse;
    }

    @Nullable
    protected OIDCAuthenticationRequest getAuthenticationRequest() {
        return this.authnRequest;
    }

    @Nullable
    protected OAuth2ClientAuthenticationContext getClientAuthenticationContext() {
        return this.clientAuthnContext;
    }

    @Nullable
    protected OIDCProviderMetadataContext getProviderMetadataContext() {
        return this.providerMetadataContext;
    }

    @Override
    @Nullable
    public ClassicHttpRequest apply(@Nullable ProfileRequestContext profileRequestContext) {
        if (profileRequestContext == null) {
            this.log.error("Profile request context is null, unable to encode request");
            return null;
        }
        MessageContext inboundMessageCtx = profileRequestContext.getInboundMessageContext();
        if (inboundMessageCtx == null) {
            this.log.error("No inbound message context");
            return null;
        }
        if (inboundMessageCtx.getMessage() == null) {
            this.log.error("No inbound message");
            return null;
        }
        if (!(inboundMessageCtx.getMessage() instanceof AuthenticationSuccessResponse)) {
            this.log.error("No inbound authentication success response");
            return null;
        }
        this.authnResponse = (AuthenticationSuccessResponse)inboundMessageCtx.getMessage();
        MessageContext outboundMsgContext = profileRequestContext.getOutboundMessageContext();
        if (outboundMsgContext == null) {
            this.log.error("Outbound message context was null");
            return null;
        }
        if (!(outboundMsgContext.getMessage() instanceof OIDCAuthenticationRequest)) {
            this.log.error("Outbound message was not an authentication request");
            return null;
        }
        this.authnRequest = (OIDCAuthenticationRequest)outboundMsgContext.getMessage();
        this.providerMetadataContext = this.providerMetadataLookupStrategy.apply(profileRequestContext);
        if (this.providerMetadataContext == null) {
            this.log.error("No provider metadata context found for peer");
            return null;
        }
        assert (this.providerMetadataContext != null);
        OIDCProviderMetadata providerMetadata = this.providerMetadataContext.getProviderInformation();
        if (providerMetadata == null) {
            this.log.error("No provider metadata found for peer");
            return null;
        }
        this.clientAuthnContext = this.oauth2ClientAuthenticationContextLookupStrategy.apply(profileRequestContext);
        if (this.clientAuthnContext == null) {
            this.log.error("No OAuth 2.0 client authentication context found");
            return null;
        }
        return this.doApply(profileRequestContext, providerMetadata);
    }

    @Nullable
    protected abstract ClassicHttpRequest doApply(@Nonnull ProfileRequestContext var1, @Nonnull OIDCProviderMetadata var2);
}

