/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.decoding.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.jose.util.IOUtils;
import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTParser;
import com.nimbusds.openid.connect.sdk.UserInfoErrorResponse;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import com.nimbusds.openid.connect.sdk.claims.UserInfo;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.oidc.rp.decoding.impl.AbstractJSONResponseDecoderFunction;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.Header;
import org.apache.hc.core5.http.HttpEntity;
import org.slf4j.Logger;

public class DefaultUserInfoResponseDecoder
extends AbstractJSONResponseDecoderFunction<UserInfoResponse> {
    @Nonnull
    public static final String USERINFO_ERROR_RESPONSE_HEADER = "WWW-Authenticate";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultUserInfoResponseDecoder.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public UserInfoResponse handleResponse(@Nullable ClassicHttpResponse httpResponse) {
        if (httpResponse == null) {
            this.log.error("HttpResponse was null, can not process response");
            return null;
        }
        try {
            int httpStatusCode = httpResponse.getCode();
            if (httpStatusCode != 200) {
                Header errorHeader = httpResponse.getHeader(USERINFO_ERROR_RESPONSE_HEADER);
                if (errorHeader != null) {
                    return UserInfoErrorResponse.parse((String)errorHeader.getValue());
                }
                this.log.warn("HTTP status code implies error response, but no error given");
                return null;
            }
            HttpEntity entity = httpResponse.getEntity();
            if (entity == null) {
                this.log.warn("HTTP response did not contain a response entity, nothing to decode");
                return null;
            }
            String contentTypeString = entity.getContentType();
            if (contentTypeString == null) {
                this.log.warn("HTTP response did not contain a content-type, must contain a content-type");
                return null;
            }
            ContentType contentType = ContentType.parse((String)contentTypeString);
            if (contentType == null) {
                this.log.warn("HTTP response did not contain a valid content-type");
                return null;
            }
            if (ContentType.APPLICATION_JWT.matches(contentType)) {
                try (InputStream input = entity.getContent();){
                    String content = IOUtils.readInputStreamToString((InputStream)input);
                    JWT parsedJwt = JWTParser.parse((String)content);
                    UserInfoSuccessResponse userInfoSuccessResponse = new UserInfoSuccessResponse(parsedJwt);
                    return userInfoSuccessResponse;
                }
            }
            if (ContentType.APPLICATION_JSON.matches(contentType)) {
                try (InputStream input = entity.getContent();){
                    String content = IOUtils.readInputStreamToString((InputStream)input);
                    Map claims = (Map)this.getObjectMapper().readValue(content, (TypeReference)new TypeReference<Map<String, Object>>(){});
                    ClaimsSet claimsSet = new ClaimsSet();
                    claimsSet.putAll(claims);
                    UserInfoSuccessResponse userInfoSuccessResponse = new UserInfoSuccessResponse(new UserInfo(claimsSet.toJSONObject()));
                    return userInfoSuccessResponse;
                }
            }
        }
        catch (IllegalArgumentException e) {
            this.log.warn("Error creating UserInfo claims set", (Throwable)e);
            return null;
        }
        catch (Exception e) {
            this.log.warn("Unable to decode UserInfo response", (Throwable)e);
            return null;
        }
        this.log.warn("Unknown UserInfo response type");
        return null;
    }
}

