/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.security.impl;

import com.nimbusds.jose.Algorithm;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.config.JSONSecurityConfiguration;
import net.shibboleth.oidc.profile.config.OIDCAuthenticationRelyingPartyProfileConfiguration;
import net.shibboleth.oidc.security.jose.SignatureSigningConfiguration;
import net.shibboleth.oidc.security.jose.impl.BasicSignatureSigningConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.relyingparty.RelyingPartyConfiguration;
import net.shibboleth.shared.annotation.constraint.NonnullElements;
import net.shibboleth.shared.annotation.constraint.NotLive;
import net.shibboleth.shared.annotation.constraint.Unmodifiable;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.context.navigate.ContextDataLookupFunction;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.ParentProfileRequestContextLookup;
import org.opensaml.security.config.SecurityConfiguration;
import org.slf4j.Logger;

public class ClientAuthenticationConfigurationLookupFunction
implements ContextDataLookupFunction<MessageContext, List<SignatureSigningConfiguration>> {
    @Nonnull
    private static final ParentProfileRequestContextLookup<MessageContext> PRC_LOOKUP = new ParentProfileRequestContextLookup();
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ClientAuthenticationConfigurationLookupFunction.class);
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    public List<SignatureSigningConfiguration> apply(@Nullable MessageContext input) {
        ArrayList<BasicSignatureSigningConfiguration> configsFiltered;
        block8: {
            ClientAuthenticationMethod method;
            ArrayList<SignatureSigningConfiguration> configs;
            block7: {
                configs = new ArrayList<SignatureSigningConfiguration>();
                String tokenEndpointAuthMethod = null;
                RelyingPartyContext rpc = this.relyingPartyContextLookupStrategy.apply((ProfileRequestContext)PRC_LOOKUP.apply((BaseContext)input));
                if (rpc != null) {
                    JSONSecurityConfiguration jsonSecConfig;
                    SecurityConfiguration defaultConfig;
                    RelyingPartyConfiguration rpConfig;
                    JSONSecurityConfiguration jsonSecConfig2;
                    Object object;
                    ProfileConfiguration pc = rpc.getProfileConfig();
                    if (pc != null && (object = pc.getSecurityConfiguration((ProfileRequestContext)PRC_LOOKUP.apply((BaseContext)input))) instanceof JSONSecurityConfiguration && (jsonSecConfig2 = (JSONSecurityConfiguration)object).getJwtSignatureSigningConfiguration() != null) {
                        configs.add(jsonSecConfig2.getJwtSignatureSigningConfiguration());
                    }
                    if (pc instanceof OIDCAuthenticationRelyingPartyProfileConfiguration) {
                        OIDCAuthenticationRelyingPartyProfileConfiguration oidcRpConfig = (OIDCAuthenticationRelyingPartyProfileConfiguration)pc;
                        tokenEndpointAuthMethod = oidcRpConfig.getTokenEndpointAuthMethod((ProfileRequestContext)PRC_LOOKUP.apply((BaseContext)input));
                    }
                    if ((rpConfig = rpc.getConfiguration()) != null && (defaultConfig = rpConfig.getSecurityConfiguration((ProfileRequestContext)PRC_LOOKUP.apply((BaseContext)input))) instanceof JSONSecurityConfiguration && (jsonSecConfig = (JSONSecurityConfiguration)defaultConfig).getJwtSignatureSigningConfiguration() != null) {
                        configs.add(jsonSecConfig.getJwtSignatureSigningConfiguration());
                    }
                }
                if (tokenEndpointAuthMethod == null) {
                    this.log.trace("Token endpoint client authentication method can not be found");
                    return CollectionSupport.emptyList();
                }
                method = new ClientAuthenticationMethod(tokenEndpointAuthMethod);
                configsFiltered = new ArrayList<BasicSignatureSigningConfiguration>();
                if (!method.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT)) break block7;
                for (SignatureSigningConfiguration config : configs) {
                    List<String> filteredForMethodAlgs = this.filterAlgorithmsAgainstFamily(JWSAlgorithm.Family.HMAC_SHA, config.getSignatureAlgorithms());
                    configsFiltered.add(this.createSignatureSigningConfiguration(config, filteredForMethodAlgs));
                }
                break block8;
            }
            if (!method.equals((Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT)) break block8;
            for (SignatureSigningConfiguration config : configs) {
                List<String> filteredForMethodAlgs = this.filterAlgorithmsAgainstFamily(JWSAlgorithm.Family.SIGNATURE, config.getSignatureAlgorithms());
                configsFiltered.add(this.createSignatureSigningConfiguration(config, filteredForMethodAlgs));
            }
        }
        return Collections.unmodifiableList(configsFiltered);
    }

    @Nonnull
    @NonnullElements
    @NotLive
    @Unmodifiable
    private List<String> filterAlgorithmsAgainstFamily(@Nonnull JWSAlgorithm.Family algFamily, @Nullable List<String> algorithms) {
        if (algorithms == null) {
            return CollectionSupport.emptyList();
        }
        List<String> filtered = algorithms.stream().filter(Objects::nonNull).filter(Predicate.not(String::isEmpty)).map(JWSAlgorithm::parse).filter(arg_0 -> algFamily.contains(arg_0)).map(Algorithm::getName).toList();
        return Collections.unmodifiableList(filtered);
    }

    @Nonnull
    private BasicSignatureSigningConfiguration createSignatureSigningConfiguration(@Nonnull SignatureSigningConfiguration signingConfig, @Nonnull List<String> algorithms) {
        BasicSignatureSigningConfiguration config = new BasicSignatureSigningConfiguration();
        config.setExcludedAlgorithms(signingConfig.getExcludedAlgorithms());
        config.setIncludedAlgorithms(signingConfig.getIncludedAlgorithms());
        config.setIncludeExcludePrecedence(signingConfig.getIncludeExcludePrecedence());
        config.setSigningCredentials(signingConfig.getSigningCredentials());
        config.setIncludeMerge(signingConfig.isIncludeMerge());
        config.setExcludeMerge(signingConfig.isExcludeMerge());
        config.setSignatureAlgorithms(algorithms);
        return config;
    }
}

