/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.security.impl;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.openid.connect.sdk.Nonce;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;

@ThreadSafe
public final class AuthenticationRequestNonceClaimLookupStrategy
implements BiFunction<ProfileRequestContext, JWTClaimsSet, String> {
    @Nonnull
    private final Function<ProfileRequestContext, OIDCAuthenticationRequest> authenticationRequestLookupStrategy;

    public AuthenticationRequestNonceClaimLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthenticationRequest> strategy) {
        this.authenticationRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Authentication request lookup strategy can not be null");
    }

    public AuthenticationRequestNonceClaimLookupStrategy() {
        this.authenticationRequestLookupStrategy = prc -> {
            Object patt2367$temp;
            MessageContext messageContext = prc.getOutboundMessageContext();
            if (messageContext != null && (patt2367$temp = messageContext.getMessage()) instanceof OIDCAuthenticationRequest) {
                OIDCAuthenticationRequest authnRequest = (OIDCAuthenticationRequest)patt2367$temp;
                return authnRequest;
            }
            return null;
        };
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext context, @Nullable JWTClaimsSet claims) {
        Nonce nonce;
        OIDCAuthenticationRequest request = this.authenticationRequestLookupStrategy.apply(context);
        Nonce nonce2 = nonce = request != null ? request.getNonce() : null;
        if (nonce == null) {
            return null;
        }
        return nonce.getValue();
    }
}

