/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.metadata.impl;

import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.ProviderMetadataResolver;
import net.shibboleth.oidc.metadata.context.OIDCProviderMetadataContext;
import net.shibboleth.oidc.metadata.criterion.IssuerIDCriterion;
import net.shibboleth.oidc.profile.messaging.context.AbstractOIDCEntityContext;
import net.shibboleth.oidc.profile.messaging.context.OIDCPeerEntityContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.resolver.CriteriaSet;
import net.shibboleth.shared.resolver.Criterion;
import net.shibboleth.shared.resolver.ResolverException;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public class OIDCProviderMetadataLookupHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(OIDCProviderMetadataLookupHandler.class);
    @NonnullAfterInit
    private ProviderMetadataResolver providerResolver;
    @Nonnull
    private Function<MessageContext, ? extends AbstractOIDCEntityContext> contextClassLookupStrategy = new ChildContextLookup(OIDCPeerEntityContext.class);
    @Nullable
    private Function<MessageContext, OIDCProviderMetadataContext> copyContextStrategy;

    public void setContextClassLookupStrategy(@Nonnull Function<MessageContext, ? extends AbstractOIDCEntityContext> strategy) {
        this.checkSetterPreconditions();
        this.contextClassLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Context class lookup strategy can not be null");
    }

    public void setCopyContextStrategy(@Nullable Function<MessageContext, OIDCProviderMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.copyContextStrategy = strategy;
    }

    public void setProviderMetadataResolver(@Nonnull ProviderMetadataResolver resolver) {
        this.checkSetterPreconditions();
        this.providerResolver = (ProviderMetadataResolver)Constraint.isNotNull((Object)resolver, (String)"ProviderMetadataResolver cannot be null");
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.providerResolver == null) {
            throw new ComponentInitializationException("ProviderMetadataResolver cannot be null");
        }
    }

    protected void doInvoke(MessageContext messageContext) throws MessageHandlerException {
        String id;
        this.ifNotInitializedThrowUninitializedComponentException();
        AbstractOIDCEntityContext entityCtx = this.contextClassLookupStrategy.apply(messageContext);
        String string = id = entityCtx != null ? entityCtx.getIdentifier() : null;
        if (entityCtx == null || id == null) {
            this.log.debug("{} OIDC entity context class '{}' missing or did not contain an issuer identifier", (Object)this.getLogPrefix(), AbstractOIDCEntityContext.class);
            return;
        }
        OIDCProviderMetadataContext existingMetadataCtx = this.resolveExisting(messageContext, id);
        if (existingMetadataCtx != null) {
            this.log.debug("{} Resolved existing provider metadata context, removing existing and re-using it", (Object)this.getLogPrefix());
            entityCtx.removeSubcontext(OIDCProviderMetadataContext.class);
            entityCtx.addSubcontext((BaseContext)existingMetadataCtx);
            return;
        }
        IssuerIDCriterion issuerCriterion = new IssuerIDCriterion(new Issuer(entityCtx.getIdentifier()));
        CriteriaSet criteria = new CriteriaSet(new Criterion[]{issuerCriterion});
        try {
            OIDCProviderMetadata issuerMetadata = (OIDCProviderMetadata)this.providerResolver.resolveSingle((Object)criteria);
            if (issuerMetadata == null) {
                this.log.debug("{} No provider metadata returned for {}", (Object)this.getLogPrefix(), (Object)entityCtx.getIdentifier());
                return;
            }
            this.log.debug("{} Found provider metadata for '{}'", (Object)this.getLogPrefix(), (Object)entityCtx.getIdentifier());
            OIDCProviderMetadataContext context = new OIDCProviderMetadataContext();
            context.setProviderInformation(issuerMetadata);
            entityCtx.addSubcontext((BaseContext)context);
        }
        catch (ResolverException e) {
            this.log.error("{} ResolverException thrown during provider metadata lookup: {}", (Object)this.getLogPrefix(), (Object)e.getMessage());
            throw new MessageHandlerException((Exception)((Object)e));
        }
    }

    @Nullable
    protected OIDCProviderMetadataContext resolveExisting(@Nonnull MessageContext messageContext, @Nonnull String issuer) {
        if (this.copyContextStrategy == null) {
            return null;
        }
        assert (this.copyContextStrategy != null);
        OIDCProviderMetadataContext existing = this.copyContextStrategy.apply(messageContext);
        if (existing != null) {
            OIDCProviderMetadata providerInformation = existing.getProviderInformation();
            if (providerInformation != null) {
                if (Objects.equals(providerInformation.getIssuer().getValue(), issuer)) {
                    this.log.debug("{} Found an existing and suitable OIDCProviderMetadataContext from which to copy ", (Object)this.getLogPrefix());
                    OIDCProviderMetadataContext copy = new OIDCProviderMetadataContext();
                    copy.setProviderInformation(existing.getProviderInformation());
                    return copy;
                }
                this.log.debug("{} Existing OIDCProviderMetadataContext was resolved, but the issuer did not match the entity context data", (Object)this.getLogPrefix());
            } else {
                this.log.debug("{} Existing OIDCProviderMetadataContext was resolved but is missing ProviderInformation data", (Object)this.getLogPrefix());
            }
        } else {
            this.log.debug("{} No existing OIDCProviderMetadataContext was resolved", (Object)this.getLogPrefix());
        }
        return null;
    }
}

