/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl;

import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.oidc.rp.impl.OIDCProxySupport;
import net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl.AbstractOIDCAuthenticationRequestMessageHandler;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public class AddStateHandler
extends AbstractOIDCAuthenticationRequestMessageHandler {
    @Nonnull
    private static final String STATE_CLAIM = "state";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddStateHandler.class);
    @Nonnull
    private Function<MessageContext, String> stateGenerationStrategy = msg -> {
        if (this.getOutboundMessageContext() != null) {
            String swfKey = this.getOutboundMessageContext().getWebflowKey();
            if (swfKey != null) {
                return OIDCProxySupport.generateState(OIDCProxySupport.generateNonce(32), swfKey);
            }
            return null;
        }
        return null;
    };

    public void setStateGenerationStrategy(@Nullable Function<MessageContext, String> strategy) {
        this.checkSetterPreconditions();
        if (strategy != null) {
            this.stateGenerationStrategy = strategy;
        }
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        String stateString = this.stateGenerationStrategy.apply(messageContext);
        if (stateString == null) {
            throw new MessageHandlerException("Generated state was null");
        }
        this.log.trace("{} Generated state '{}'", (Object)this.getLogPrefix(), (Object)stateString);
        State state = new State(stateString);
        this.getAuthenticationRequest().setState(state);
        ClaimsSet claims = this.getAuthenticationRequest().getRequestObjectClaimsSet();
        if (claims != null) {
            this.log.trace("{} Adding state to JWT RequestObject", (Object)this.getLogPrefix());
            claims.setClaim(STATE_CLAIM, (Object)state);
        }
    }
}

