/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl;

import com.nimbusds.openid.connect.sdk.OIDCClaimsRequest;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl.AbstractOIDCAuthenticationRequestActionMessageHandler;
import net.shibboleth.shared.logic.FunctionSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddRequestedClaimsHandler
extends AbstractOIDCAuthenticationRequestActionMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddRequestedClaimsHandler.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCClaimsRequest> requestedClaimsHook = FunctionSupport.constant(null);

    public void setRequestedClaimsHook(@Nullable Function<ProfileRequestContext, OIDCClaimsRequest> hook) {
        this.checkSetterPreconditions();
        if (hook != null) {
            this.requestedClaimsHook = hook;
        }
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.getAuthenticationRequest().setProviderSupportsClaimsParameter(this.getProviderMetadata().supportsClaimsParam());
        if (!this.getProviderMetadata().supportsClaimsParam()) {
            this.log.trace("{} OpenID Provider does not support the 'claims' parameter", (Object)this.getLogPrefix());
            return;
        }
        OIDCClaimsRequest requestedClaims = this.requestedClaimsHook.apply(this.lookupProfileRequestContext(messageContext));
        if (requestedClaims != null) {
            this.getAuthenticationRequest().setRequestedClaims(requestedClaims);
            this.log.trace("{} Added requested claims '{}' to the authentication request", (Object)this.getLogPrefix(), (Object)requestedClaims);
        } else {
            this.log.trace("{} No individual claims requested", (Object)this.getLogPrefix());
        }
    }
}

