/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.Prompt;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl.AbstractOIDCAuthenticationRequestActionMessageHandler;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddPassiveAuthenticationHandler
extends AbstractOIDCAuthenticationRequestActionMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddPassiveAuthenticationHandler.class);

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        BaseContext baseContext;
        ProfileRequestContext prc = this.lookupProfileRequestContext(messageContext);
        boolean isPassive = false;
        if (prc != null && (baseContext = prc.getParent()) instanceof AuthenticationContext) {
            AuthenticationContext authnContext = (AuthenticationContext)baseContext;
            isPassive = authnContext.isPassive();
        }
        if (isPassive) {
            this.log.trace("{} Setting 'prompt=none' for OIDC AuthnRequest", (Object)this.getLogPrefix());
            try {
                this.getAuthenticationRequest().setPrompt(Prompt.parse((String)Prompt.Type.NONE.toString()));
            }
            catch (ParseException e) {
                throw new MessageHandlerException("Unable to honour passive authentication requirement, setting prompt to 'none' has failed", (Exception)((Object)e));
            }
        } else {
            this.log.trace("{} No passive authentication requirement, so prompt=none has not been set", (Object)this.getLogPrefix());
        }
    }
}

