/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl;

import com.nimbusds.openid.connect.sdk.Nonce;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.oidc.rp.impl.OIDCProxySupport;
import net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl.AbstractOIDCAuthenticationRequestActionMessageHandler;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class AddNonceHandler
extends AbstractOIDCAuthenticationRequestActionMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddNonceHandler.class);
    @Nonnull
    private Function<ProfileRequestContext, Nonce> nonceGenerationStrategy = prc -> new Nonce(OIDCProxySupport.generateNonce(16));

    public void setNonceGenerationStrategy(@Nonnull Function<ProfileRequestContext, Nonce> strategy) {
        this.checkSetterPreconditions();
        this.nonceGenerationStrategy = (Function)Constraint.isNotNull(strategy, (String)"Nonce generation strategy can not be null");
    }

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.getAuthenticationRequest().setNonce(this.nonceGenerationStrategy.apply(this.lookupProfileRequestContext(messageContext)));
        this.log.trace("{} Added nonce '{}' to authentication request", (Object)this.getLogPrefix(), (Object)this.getAuthenticationRequest().getNonce());
    }
}

