/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.Prompt;
import java.time.Duration;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl.AbstractOIDCAuthenticationRequestActionMessageHandler;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public class AddForceAuthenticationHandler
extends AbstractOIDCAuthenticationRequestActionMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddForceAuthenticationHandler.class);

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        if (this.getProfileConfiguration().isForceAuthn(this.lookupProfileRequestContext(messageContext))) {
            this.log.trace("{} Setting prompt=login and max_age=0 (ForceAuthn) for OIDC AuthnRequest", (Object)this.getLogPrefix());
            try {
                this.getAuthenticationRequest().setPrompt(Prompt.parse((String)Prompt.Type.LOGIN.toString()));
                this.getAuthenticationRequest().setMaxAge(Duration.ofSeconds(0L));
            }
            catch (ParseException e) {
                throw new MessageHandlerException("Unable to honour force-authn, setting prompt to force-login as failed", (Exception)((Object)e));
            }
        } else {
            this.log.trace("{} No ForceAuthn requirement, so no prompt or max_age set", (Object)this.getLogPrefix());
        }
    }
}

