/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl;

import com.nimbusds.oauth2.sdk.ParseException;
import com.nimbusds.openid.connect.sdk.Display;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl.AbstractOIDCAuthenticationRequestActionMessageHandler;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public class AddDisplayHandler
extends AbstractOIDCAuthenticationRequestActionMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AddDisplayHandler.class);

    protected void doInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        String display = this.getProfileConfiguration().getDisplay(this.lookupProfileRequestContext(messageContext));
        if (StringSupport.trimOrNull((String)display) != null) {
            try {
                this.getAuthenticationRequest().setDisplay(Display.parse((String)display));
                this.log.trace("Adding 'display' request parameter value '{}'", (Object)display);
            }
            catch (ParseException e) {
                throw new MessageHandlerException("Unable to add a 'display' value of: " + display);
            }
        }
    }
}

