/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.OutboundMessageHandlerContext;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public abstract class AbstractOIDCAuthenticationRequestMessageHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractOIDCAuthenticationRequestMessageHandler.class);
    @Nonnull
    private Function<MessageContext, OutboundMessageHandlerContext> outboundMessageHandlerContextLookupStrategy = new ChildContextLookup(OutboundMessageHandlerContext.class);
    @Nonnull
    private Function<MessageContext, OIDCAuthenticationRequest> authenticationRequestLookupStrategy = mc -> {
        Object patt2763$temp = mc.getMessage();
        if (patt2763$temp instanceof OIDCAuthenticationRequest) {
            OIDCAuthenticationRequest request = (OIDCAuthenticationRequest)patt2763$temp;
            return request;
        }
        return null;
    };
    @NonnullBeforeExec
    private OutboundMessageHandlerContext outboundMessageContext;
    @NonnullBeforeExec
    private OIDCAuthenticationRequest authnRequest;

    protected AbstractOIDCAuthenticationRequestMessageHandler() {
    }

    @NonnullBeforeExec
    protected OutboundMessageHandlerContext getOutboundMessageContext() {
        return this.outboundMessageContext;
    }

    @NonnullBeforeExec
    protected OIDCAuthenticationRequest getAuthenticationRequest() {
        return this.authnRequest;
    }

    public void setAuthenticationRequestLookupStrategy(@Nonnull Function<MessageContext, OIDCAuthenticationRequest> strategy) {
        this.checkSetterPreconditions();
        this.authenticationRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthenticationRequestLookupStrategy lookup strategy cannot be null");
    }

    public void setOutboundMessageHandlerContextLookupStrategy(@Nonnull Function<MessageContext, OutboundMessageHandlerContext> strategy) {
        this.checkSetterPreconditions();
        this.outboundMessageHandlerContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"outboundMessageHandlerContextLookupStrategy can not be null");
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        this.outboundMessageContext = this.outboundMessageHandlerContextLookupStrategy.apply(messageContext);
        if (this.outboundMessageContext == null) {
            this.log.debug("{} Outbound message context is null", (Object)this.getLogPrefix());
            throw new MessageHandlerException("Outbound message context is null");
        }
        this.authnRequest = this.authenticationRequestLookupStrategy.apply(messageContext);
        if (this.authnRequest == null) {
            this.log.debug("{} OIDC authentication request is null", (Object)this.getLogPrefix());
            throw new MessageHandlerException("OIDC authentication request is null");
        }
        return super.doPreInvoke(messageContext);
    }
}

