/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.impl;

import com.google.common.base.Predicates;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import jakarta.servlet.http.HttpServletRequest;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.metadata.context.OIDCProviderMetadataContext;
import net.shibboleth.oidc.profile.config.OIDCAuthenticationRelyingPartyProfileConfiguration;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.oidc.profile.messaging.context.OIDCPeerEntityContext;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.NonnullSupplier;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.ParentProfileRequestContextLookup;
import org.slf4j.Logger;

public abstract class AbstractOIDCAuthenticationRequestActionMessageHandler
extends AbstractMessageHandler {
    @Nonnull
    private static final ParentProfileRequestContextLookup<MessageContext> PRC_LOOKUP = new ParentProfileRequestContextLookup();
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractOIDCAuthenticationRequestActionMessageHandler.class);
    @Nonnull
    private Function<MessageContext, OIDCProviderMetadataContext> providerMetadataLookupStrategy = new ChildContextLookup(OIDCProviderMetadataContext.class).compose((Function)new ChildContextLookup(OIDCPeerEntityContext.class));
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @NonnullBeforeExec
    private OIDCAuthenticationRequest authnRequest;
    @NonnullBeforeExec
    private OIDCProviderMetadata providerMetadata;
    @NonnullBeforeExec
    private OIDCAuthenticationRelyingPartyProfileConfiguration profileConfiguration;
    @Nullable
    private NonnullSupplier<HttpServletRequest> httpServletRequestSupplier;

    protected AbstractOIDCAuthenticationRequestActionMessageHandler() {
    }

    public void setHttpServletRequestSupplier(@Nullable NonnullSupplier<HttpServletRequest> requestSupplier) {
        this.checkSetterPreconditions();
        this.httpServletRequestSupplier = requestSupplier;
    }

    @Nullable
    public HttpServletRequest getHttpServletRequest() {
        if (this.httpServletRequestSupplier != null) {
            return (HttpServletRequest)this.httpServletRequestSupplier.get();
        }
        return null;
    }

    @Nullable
    public NonnullSupplier<HttpServletRequest> getHttpServletRequestSupplier() {
        return this.httpServletRequestSupplier;
    }

    @NonnullBeforeExec
    protected OIDCAuthenticationRequest getAuthenticationRequest() {
        return this.authnRequest;
    }

    @NonnullBeforeExec
    protected OIDCAuthenticationRelyingPartyProfileConfiguration getProfileConfiguration() {
        return this.profileConfiguration;
    }

    @NonnullBeforeExec
    protected OIDCProviderMetadata getProviderMetadata() {
        return this.providerMetadata;
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setProviderMetadataLookupStrategy(@Nonnull Function<MessageContext, OIDCProviderMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.providerMetadataLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Provider metadata lookup strategy can not be null");
    }

    @Nullable
    protected <T> Function<MessageContext, T> adapt(@Nullable Function<ProfileRequestContext, T> function) {
        if (function == null) {
            return null;
        }
        return function.compose(PRC_LOOKUP);
    }

    @Nullable
    protected ProfileRequestContext lookupProfileRequestContext(@Nonnull MessageContext messageContext) {
        return (ProfileRequestContext)PRC_LOOKUP.apply((BaseContext)messageContext);
    }

    @Nullable
    protected Predicate<MessageContext> adapt(@Nullable Predicate<ProfileRequestContext> predicate) {
        if (predicate == null) {
            return null;
        }
        return Predicates.compose(predicate::test, arg_0 -> PRC_LOOKUP.apply(arg_0));
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        ProfileConfiguration profileConfiguration;
        if (!(messageContext.getMessage() instanceof OIDCAuthenticationRequest)) {
            throw new MessageHandlerException("Message was not an authentication request");
        }
        this.authnRequest = (OIDCAuthenticationRequest)messageContext.getMessage();
        OIDCProviderMetadataContext providerMetadataContext = this.providerMetadataLookupStrategy.apply(messageContext);
        if (providerMetadataContext == null) {
            throw new MessageHandlerException("No provider metadata context found for peer");
        }
        this.providerMetadata = providerMetadataContext.getProviderInformation();
        if (this.providerMetadata == null) {
            throw new MessageHandlerException("No provider metadata context found for peer");
        }
        Function<MessageContext, RelyingPartyContext> adaptedFunction = this.adapt(this.relyingPartyContextLookupStrategy);
        assert (adaptedFunction != null);
        RelyingPartyContext rpCtx = adaptedFunction.apply(messageContext);
        if (rpCtx != null && rpCtx.getConfiguration() != null && (profileConfiguration = rpCtx.getProfileConfig()) instanceof OIDCAuthenticationRelyingPartyProfileConfiguration) {
            OIDCAuthenticationRelyingPartyProfileConfiguration rpConfig;
            this.profileConfiguration = rpConfig = (OIDCAuthenticationRelyingPartyProfileConfiguration)profileConfiguration;
        }
        if (this.profileConfiguration == null) {
            throw new MessageHandlerException("Profile configuration could not found");
        }
        return super.doPreInvoke(messageContext);
    }
}

