/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.common.contenttype.ContentType;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.UserInfoResponse;
import com.nimbusds.openid.connect.sdk.UserInfoSuccessResponse;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AccessTokenResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.UserInfoResponseContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class ValidateUserInfoJSONObjectClaims
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ValidateUserInfoJSONObjectClaims.class);
    @Nonnull
    private Function<ProfileRequestContext, UserInfoResponseContext> userInfoResponseContextLookupStrategy = new ChildContextLookup(UserInfoResponseContext.class).compose((Function)new InboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, AccessTokenResponseContext> tokenResponseContextLookupStrategy = new ChildContextLookup(AccessTokenResponseContext.class).compose((Function)new InboundMessageContextLookup());
    @NonnullBeforeExec
    private UserInfoResponseContext userInfoCtx;
    @NonnullBeforeExec
    private UserInfoSuccessResponse userInfo;
    @NonnullBeforeExec
    private JWTClaimsSet idTokenClaims;

    public void setTokenResponseContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AccessTokenResponseContext> strategy) {
        this.checkSetterPreconditions();
        this.tokenResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TokenResponseContext lookup strategy cannot be null");
    }

    public void setUserInfoResponseContextLookupStrategy(@Nonnull Function<ProfileRequestContext, UserInfoResponseContext> strategy) {
        this.checkSetterPreconditions();
        this.userInfoResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"UserInfoResponseContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.userInfoCtx = this.userInfoResponseContextLookupStrategy.apply(profileRequestContext);
        UserInfoSuccessResponse userInfoSuccessResponse = this.userInfo = this.userInfoCtx != null ? this.userInfoCtx.getUserInfo() : null;
        if (this.userInfo == null) {
            this.log.debug("{} No UserInfo response returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        AccessTokenResponseContext tokenResponseCtx = this.tokenResponseContextLookupStrategy.apply(profileRequestContext);
        if (tokenResponseCtx == null) {
            this.log.debug("{} No AccessTokenResponseContext returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        OIDCTokenResponse tokenResponse = tokenResponseCtx.getTokenResponse();
        if (tokenResponse == null || tokenResponse.getOIDCTokens().getIDToken() == null) {
            this.log.debug("{} AccessTokenResponseContext did not contain an id_token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        try {
            this.idTokenClaims = tokenResponse.getOIDCTokens().getIDToken().getJWTClaimsSet();
            if (this.idTokenClaims == null) {
                this.log.debug("{} AccessTokenResponseContext did not contain an id_token with accessible claims, possibly still encrypted", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidIdToken");
                return false;
            }
        }
        catch (ParseException e) {
            this.log.debug("{} Unable to parse claims from id_token", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.trace("{} Validating UserInfo JSON Object claims", (Object)this.getLogPrefix());
        assert (this.userInfo != null);
        ClaimsSet claims = this.resolveClaimsSet((UserInfoResponse)this.userInfo);
        if (claims == null) {
            this.log.debug("{} UserInfo claims can not be resolved", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidUserInfoClaims");
            return;
        }
        String subFromUserInfo = claims.getStringClaim("sub");
        if (subFromUserInfo == null) {
            this.log.debug("{} UserInfo claims does not contain the 'sub' claim, it must", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidUserInfoClaims");
            return;
        }
        if (!this.idTokenClaims.getSubject().equals(subFromUserInfo)) {
            this.log.error("{} UserInfo claims about subject '{}' but id_token about subject '{}', mismatch", new Object[]{this.getLogPrefix(), subFromUserInfo, this.idTokenClaims.getSubject()});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidUserInfoClaims");
            return;
        }
        this.log.debug("{} UserInfo claims are valid for '{}'", (Object)this.getLogPrefix(), (Object)claims.getStringClaim("sub"));
    }

    @Nullable
    private ClaimsSet resolveClaimsSet(@Nonnull UserInfoResponse response) {
        if (!response.indicatesSuccess()) {
            return null;
        }
        UserInfoSuccessResponse successResponse = response.toSuccessResponse();
        if (successResponse.getEntityContentType() == ContentType.APPLICATION_JWT) {
            try {
                JWTClaimsSet claims = successResponse.getUserInfoJWT().getJWTClaimsSet();
                if (claims == null) {
                    this.log.debug("{} UserInfo claims are not available, check response is not still encrypted", (Object)this.getLogPrefix());
                    return null;
                }
                ClaimsSet claimsConverted = new ClaimsSet();
                claimsConverted.putAll(claims.toJSONObject());
                return claimsConverted;
            }
            catch (ParseException e) {
                this.log.warn("{} UserInfo claims could not be extracted from the JWT claims set", (Object)this.getLogPrefix(), (Object)e);
                return null;
            }
        }
        if (successResponse.getEntityContentType() == ContentType.APPLICATION_JSON) {
            return successResponse.getUserInfo();
        }
        this.log.debug("{} UserInfo claims are not available, unknown entity content type", (Object)this.getLogPrefix());
        return null;
    }
}

