/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.oauth2.sdk.id.State;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class ValidateResponseState
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    @NotEmpty
    private final Logger log = LoggerFactory.getLogger(ValidateResponseState.class);

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        OIDCAuthenticationRequest authnRequest = this.getAuthenticationRequest();
        if (authnRequest == null) {
            this.log.error("{} The authentication request does not exist, state can not be checked", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        AuthenticationSuccessResponse authnResponse = this.getAuthenticationResponse();
        if (authnResponse == null) {
            this.log.error("{} The authentication response does not exist, state can not be checked", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        this.log.trace("{} Proxy authentication request state '{}' was returned in the response as '{}'", new Object[]{this.getLogPrefix(), authnRequest.getState(), authnResponse.getState()});
        if (authnRequest.getState() == null || authnResponse.getState() == null) {
            this.log.error("{} The state parameter was not present in either the request or response, state is mandatory for proxy OIDC requests", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        State authnRequestState = authnRequest.getState();
        State authnResponseState = authnResponse.getState();
        if (authnRequestState == null || authnResponseState == null || !authnRequestState.equals((Object)authnResponseState)) {
            this.log.error("{} Request state '{}' did not match response state '{}', has it been tampered with!", new Object[]{this.getLogPrefix(), authnRequestState, authnResponseState});
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"NoCredentials");
            return;
        }
        this.log.debug("{} OIDC request and response state match, continuing", (Object)this.getLogPrefix());
    }
}

