/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import java.time.Duration;
import java.time.Instant;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AccessTokenResponseContext;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class ValidateOAuthAccessTokenResponse
extends AbstractProfileAction {
    @Nonnull
    @NotEmpty
    private final Logger log = LoggerFactory.getLogger(ValidateOAuthAccessTokenResponse.class);
    @Nonnull
    private Function<ProfileRequestContext, AccessTokenResponseContext> tokenResponseContextLookupStrategy = new ChildContextLookup(AccessTokenResponseContext.class, true).compose((Function)new InboundMessageContextLookup());

    public void setTokenResponseContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AccessTokenResponseContext> strategy) {
        this.checkSetterPreconditions();
        this.tokenResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TokenResponseContext lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        AccessTokenResponseContext responseCtx = this.tokenResponseContextLookupStrategy.apply(profileRequestContext);
        if (responseCtx == null) {
            this.log.debug("{} No TokenResponseContext returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        OIDCTokenResponse tokenResponse = responseCtx.getTokenResponse();
        if (tokenResponse == null) {
            this.log.warn("{} No Access Token response found, response invalid", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAcessToken");
            return;
        }
        if (!tokenResponse.indicatesSuccess()) {
            if (this.log.isWarnEnabled()) {
                this.log.warn("{} Error response found instead of access token response", (Object)this.getLogPrefix());
            }
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAcessToken");
            return;
        }
        if (tokenResponse.getOIDCTokens().getIDToken() == null) {
            this.log.warn("{} Access token response is invalid, no id_token found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAcessToken");
            return;
        }
        if (tokenResponse.getTokens().getAccessToken() == null) {
            this.log.warn("{} Access token response is invalid, no access_token found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAcessToken");
            return;
        }
        if (tokenResponse.getTokens().getBearerAccessToken() == null) {
            this.log.warn("{} Access token response is invalid, bearer token_type required", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAcessToken");
            return;
        }
        Instant tokenResponseCreatedAt = responseCtx.getTokenResponseCreatedAt();
        if (tokenResponse.getTokens().getAccessToken().getLifetime() != 0L && tokenResponseCreatedAt != null) {
            Instant now = Instant.now();
            Instant expiresAt = tokenResponseCreatedAt.plus(Duration.ofSeconds(tokenResponse.getTokens().getAccessToken().getLifetime()));
            if (expiresAt.isBefore(now)) {
                this.log.warn("{} Access token response is invalid, token has expired", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAcessToken");
                return;
            }
        }
    }
}

