/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.profile.messaging.context.OIDCPeerEntityContext;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class PrepareOIDCInboundMessageContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(PrepareOIDCInboundMessageContext.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, String> identifierLookupStrategy;
    @Nullable
    private String identifier;
    @Nonnull
    private Predicate<ProfileRequestContext> addToExistingInboundMessageContextPredicate = PredicateSupport.alwaysFalse();

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.identifierLookupStrategy == null) {
            throw new ComponentInitializationException("IdentifierLookupStrategy cannot be null");
        }
    }

    public void setAddToExistingInboundMessageContext(boolean flag) {
        this.checkSetterPreconditions();
        this.addToExistingInboundMessageContextPredicate = flag ? PredicateSupport.alwaysTrue() : PredicateSupport.alwaysFalse();
    }

    public void setAddToExistingInboundMessageContextPredicate(@Nonnull Predicate<ProfileRequestContext> predicate) {
        this.checkSetterPreconditions();
        this.addToExistingInboundMessageContextPredicate = (Predicate)Constraint.isNotNull(predicate, (String)"The predicate can not be null");
    }

    public void setIdentiferLookupStrategy(@Nonnull Function<ProfileRequestContext, String> strategy) {
        this.checkSetterPreconditions();
        this.identifierLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Identifier lookup strategy can not be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        this.identifier = this.identifierLookupStrategy.apply(profileRequestContext);
        if (this.identifier == null) {
            this.log.warn("{} No identifier returned from lookup function", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        MessageContext msgCtx = null;
        if (this.addToExistingInboundMessageContextPredicate.test(profileRequestContext)) {
            msgCtx = profileRequestContext.getInboundMessageContext();
            if (msgCtx == null) {
                this.log.warn("{} Profile request context did not contain an inbound message context", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
                return;
            }
        } else {
            msgCtx = new MessageContext();
            profileRequestContext.setInboundMessageContext(msgCtx);
        }
        OIDCPeerEntityContext peerContext = (OIDCPeerEntityContext)msgCtx.ensureSubcontext(OIDCPeerEntityContext.class);
        peerContext.setIdentifier(this.identifier);
        this.log.debug("{} Initialized inbound context for OIDC authentication message to {}", (Object)this.getLogPrefix(), (Object)this.identifier);
    }
}

