/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.context.OIDCMetadataContext;
import net.shibboleth.oidc.metadata.context.OIDCProviderMetadataContext;
import net.shibboleth.oidc.profile.messaging.context.OIDCPeerEntityContext;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class InitializeOutboundAuthorizationRequestMessageContext
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeOutboundAuthorizationRequestMessageContext.class);
    @NonnullBeforeExec
    private OIDCPeerEntityContext peerEntityCtx;
    @Nonnull
    private Function<ProfileRequestContext, OIDCMetadataContext> oidcClientMetadataCtxLookupStrategy = new ChildContextLookup(OIDCMetadataContext.class).compose((Function)new InboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyCtxLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);

    public void setOIDCClientMetadataContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCMetadataContext> strgy) {
        this.checkSetterPreconditions();
        this.oidcClientMetadataCtxLookupStrategy = (Function)Constraint.isNotNull(strgy, (String)"Injected Metadata Strategy cannot be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyCtxLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        RelyingPartyContext relyingPartyCtx = this.relyingPartyCtxLookupStrategy.apply(profileRequestContext);
        if (relyingPartyCtx == null) {
            this.log.error("{} No relying party context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        BaseContext identifyingCtx = relyingPartyCtx.getRelyingPartyIdContextTree();
        if (!(identifyingCtx instanceof OIDCPeerEntityContext)) {
            this.log.debug("{} No OIDC peer entity context found via relying party context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidRelyingPartyContext");
            return false;
        }
        this.peerEntityCtx = (OIDCPeerEntityContext)identifyingCtx;
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        super.doExecute(profileRequestContext);
        MessageContext msgCtx = new MessageContext();
        profileRequestContext.setOutboundMessageContext(msgCtx);
        OIDCPeerEntityContext outboundPeerContext = (OIDCPeerEntityContext)msgCtx.ensureSubcontext(OIDCPeerEntityContext.class);
        outboundPeerContext.setIdentifier(this.peerEntityCtx.getIdentifier());
        OIDCProviderMetadataContext inboundProviderMetadata = (OIDCProviderMetadataContext)this.peerEntityCtx.getSubcontext(OIDCProviderMetadataContext.class);
        if (inboundProviderMetadata != null) {
            OIDCProviderMetadataContext outMetadata = new OIDCProviderMetadataContext();
            outMetadata.setProviderInformation(inboundProviderMetadata.getProviderInformation());
            outboundPeerContext.addSubcontext((BaseContext)outMetadata);
        }
        this.log.debug("{} Initialized outbound message context", (Object)this.getLogPrefix());
    }
}

