/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.jose.JOSEObjectType;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.SignedJWT;
import com.nimbusds.oauth2.sdk.auth.ClientAuthentication;
import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import com.nimbusds.oauth2.sdk.auth.ClientSecretBasic;
import com.nimbusds.oauth2.sdk.auth.ClientSecretJWT;
import com.nimbusds.oauth2.sdk.auth.ClientSecretPost;
import com.nimbusds.oauth2.sdk.auth.PrivateKeyJWT;
import com.nimbusds.oauth2.sdk.auth.Secret;
import com.nimbusds.oauth2.sdk.id.ClientID;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.oidc.rp.impl.OIDCProxySupport;
import net.shibboleth.oidc.authn.context.OAuth2ClientAuthenticationContext;
import net.shibboleth.oidc.metadata.context.OIDCProviderMetadataContext;
import net.shibboleth.oidc.profile.config.OIDCAuthenticationRelyingPartyProfileConfiguration;
import net.shibboleth.oidc.profile.messaging.context.OIDCPeerEntityContext;
import net.shibboleth.oidc.security.credential.ClientSecretCredential;
import net.shibboleth.oidc.security.impl.JWSTokenSigner;
import net.shibboleth.oidc.security.jose.SignatureException;
import net.shibboleth.oidc.security.jose.SignatureSigningParameters;
import net.shibboleth.oidc.security.jose.context.SecurityParametersContext;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import net.shibboleth.shared.primitive.StringSupport;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.ParentProfileRequestContextLookup;
import org.slf4j.Logger;

public class InitializeOAuth2ClientAuthenticationMethodHandler
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeOAuth2ClientAuthenticationMethodHandler.class);
    @Nonnull
    private static final ParentProfileRequestContextLookup<MessageContext> PRC_LOOKUP = new ParentProfileRequestContextLookup();
    @Nonnull
    private Function<MessageContext, OAuth2ClientAuthenticationContext> oauth2ClientAuthenticationContextLookupStrategy = new ChildContextLookup(OAuth2ClientAuthenticationContext.class, true).compose((Function)new ChildContextLookup(OIDCPeerEntityContext.class));
    @NonnullBeforeExec
    private OAuth2ClientAuthenticationContext oauth2ClientAuthenticationContext;
    @Nonnull
    private Function<MessageContext, OIDCProviderMetadataContext> providerMetadataLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
    @Nonnull
    private Function<MessageContext, OIDCPeerEntityContext> oidcPeerEntityContextLookupStrategy;
    @NonnullBeforeExec
    private OIDCAuthenticationRelyingPartyProfileConfiguration profileConfiguration;
    @Nonnull
    private Function<MessageContext, SecurityParametersContext> securityParametersContextLookupStrategy = new ChildContextLookup(SecurityParametersContext.class);
    @Nonnull
    private Duration jwtBearerExpiryOffset;
    @Nullable
    private SecurityParametersContext jwtBearerClientAuthSecurityParameters;
    @NonnullBeforeExec
    private OIDCProviderMetadata providerMetadata;
    @Nullable
    private ClientSecretCredential clientCredential;
    @Nullable
    private String clientAuthMethod;
    @Nullable
    private String clientId;
    @Nullable
    private OIDCPeerEntityContext peerEntityContext;

    public InitializeOAuth2ClientAuthenticationMethodHandler() {
        this.providerMetadataLookupStrategy = new ChildContextLookup(OIDCProviderMetadataContext.class).compose((Function)new ChildContextLookup(OIDCPeerEntityContext.class));
        this.jwtBearerExpiryOffset = Duration.ofSeconds(30L);
        this.oidcPeerEntityContextLookupStrategy = new ChildContextLookup(OIDCPeerEntityContext.class);
    }

    public void setOidcPeerEntityContextLookupStrategy(Function<MessageContext, OIDCPeerEntityContext> strategy) {
        this.checkSetterPreconditions();
        this.oidcPeerEntityContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"PeerEntity Context Lookup Strategy can not be null");
    }

    public void setJwtBearerExpiryOffset(@Nonnull Duration expiry) {
        this.checkSetterPreconditions();
        this.jwtBearerExpiryOffset = (Duration)Constraint.isNotNull((Object)expiry, (String)"jwtBearerExpiryOffset can not be null");
    }

    public void setProviderMetadataLookupStrategy(@Nonnull Function<MessageContext, OIDCProviderMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.providerMetadataLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Provider metadata lookup strategy can not be null");
    }

    public void setSecurityParametersContextLookupStrategy(@Nonnull Function<MessageContext, SecurityParametersContext> strategy) {
        this.checkSetterPreconditions();
        this.securityParametersContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"JWTSecurityParametersContext lookup strategy cannot be null");
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setOAuth2ClientAuthenticationContextLookupStrategy(@Nonnull Function<MessageContext, OAuth2ClientAuthenticationContext> strgy) {
        this.checkSetterPreconditions();
        this.oauth2ClientAuthenticationContextLookupStrategy = (Function)Constraint.isNotNull(strgy, (String)"OAuth2 client authentication context lookup strategy cannot be null");
    }

    protected boolean doPreInvoke(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        ProfileConfiguration profileConfiguration;
        if (!super.doPreInvoke(messageContext)) {
            return false;
        }
        this.oauth2ClientAuthenticationContext = this.oauth2ClientAuthenticationContextLookupStrategy.apply(messageContext);
        if (this.oauth2ClientAuthenticationContext == null) {
            this.log.error("{} No OAuth2 client authentication context found or created", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No OAuth2 client authentication context found or created");
        }
        RelyingPartyContext rpCtx = this.relyingPartyContextLookupStrategy.compose(PRC_LOOKUP).apply(messageContext);
        if (rpCtx != null && rpCtx.getConfiguration() != null && (profileConfiguration = rpCtx.getProfileConfig()) instanceof OIDCAuthenticationRelyingPartyProfileConfiguration) {
            OIDCAuthenticationRelyingPartyProfileConfiguration rpConfig;
            this.profileConfiguration = rpConfig = (OIDCAuthenticationRelyingPartyProfileConfiguration)profileConfiguration;
        }
        if (this.profileConfiguration == null) {
            this.log.error("{} Profile configuration not found", (Object)this.getLogPrefix());
            throw new MessageHandlerException("No OAuth2 client authentication context found or created");
        }
        this.jwtBearerClientAuthSecurityParameters = this.securityParametersContextLookupStrategy.apply(messageContext);
        this.peerEntityContext = this.oidcPeerEntityContextLookupStrategy.apply(messageContext);
        OIDCProviderMetadataContext providerCtx = this.providerMetadataLookupStrategy.apply(messageContext);
        if (providerCtx == null || providerCtx.getProviderInformation() == null) {
            this.log.error("{} Provider metadata not found", (Object)this.getLogPrefix());
            throw new MessageHandlerException("Provider metadata not found");
        }
        this.providerMetadata = providerCtx.getProviderInformation();
        if (this.providerMetadata == null) {
            throw new MessageHandlerException("No provider metadata found from profile configuration");
        }
        this.clientAuthMethod = this.profileConfiguration.getTokenEndpointAuthMethod((ProfileRequestContext)PRC_LOOKUP.apply((BaseContext)messageContext));
        String localClientAuthMethod = this.clientAuthMethod;
        if (localClientAuthMethod == null || localClientAuthMethod.isEmpty()) {
            throw new MessageHandlerException("No client authentication method found from profile configuration");
        }
        this.clientId = this.profileConfiguration.getClientId((ProfileRequestContext)PRC_LOOKUP.apply((BaseContext)messageContext));
        if (this.clientId == null) {
            throw new MessageHandlerException("No client_id found from profile configuration");
        }
        this.clientCredential = this.profileConfiguration.getClientCredential((ProfileRequestContext)PRC_LOOKUP.apply((BaseContext)messageContext));
        return true;
    }

    protected void doInvoke(MessageContext messageContext) throws MessageHandlerException {
        ClientAuthenticationMethod method = new ClientAuthenticationMethod(this.clientAuthMethod);
        Object clientAuthentication = null;
        if (method.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC) || method.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_POST)) {
            if (this.clientCredential == null) {
                throw new MessageHandlerException("No client secret credential found from profile configuration, can not construct client authenticaton");
            }
            assert (this.clientCredential != null);
            Secret secret = new Secret(this.clientCredential.getSecret());
            if (secret.expired()) {
                this.log.warn("{} Client secret has expired for client '{}'", (Object)this.getLogPrefix(), (Object)this.clientId);
                throw new MessageHandlerException("Client secret has expired");
            }
            clientAuthentication = method.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_BASIC) ? new ClientSecretBasic(new ClientID(this.clientId), secret) : new ClientSecretPost(new ClientID(this.clientId), secret);
        } else if (method.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT)) {
            this.verifySuitableClientSecretJWTSecurityContext();
            clientAuthentication = new ClientSecretJWT(this.buildClientAuthenticationJwt(messageContext));
        } else if (method.equals((Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT)) {
            this.verifySuitablePrivateKetJWTSecurityContext();
            clientAuthentication = new PrivateKeyJWT(this.buildClientAuthenticationJwt(messageContext));
        } else {
            this.log.warn("{}: Client authentication method '{}' not supported for client '{}'", new Object[]{this.getLogPrefix(), method, this.clientId});
        }
        if (clientAuthentication == null) {
            throw new MessageHandlerException("Client authentication could not be constructed");
        }
        this.oauth2ClientAuthenticationContext.setClientAuthentication((ClientAuthentication)clientAuthentication);
        this.log.debug("{} Initialized OAuth2 Client Authentication Context: Found client authentication mode '{}' for client '{}'", new Object[]{this.getLogPrefix(), clientAuthentication.getMethod(), clientAuthentication.getClientID()});
    }

    private void verifySuitableClientSecretJWTSecurityContext() throws MessageHandlerException {
        SecurityParametersContext bearerSecurityParams = this.jwtBearerClientAuthSecurityParameters;
        if (bearerSecurityParams == null || bearerSecurityParams.getSignatureSigningParameters() == null) {
            throw new MessageHandlerException("Missing security parameters needed to sign client_secret_jwt");
        }
        SignatureSigningParameters signatureSigningParameters = bearerSecurityParams.getSignatureSigningParameters();
        assert (signatureSigningParameters != null);
        if (signatureSigningParameters.getSignatureAlgorithm() == null || signatureSigningParameters.getSigningCredential() == null) {
            throw new MessageHandlerException("Missing credential needed to sign client_secret_jwt");
        }
        JWSAlgorithm jwsAlgorithm = new JWSAlgorithm(signatureSigningParameters.getSignatureAlgorithm());
        if (!JWSAlgorithm.Family.HMAC_SHA.contains((Object)jwsAlgorithm)) {
            throw new MessageHandlerException("Trying to construct client_secret_jwt using the wrong algorithm: " + String.valueOf(jwsAlgorithm));
        }
    }

    private void verifySuitablePrivateKetJWTSecurityContext() throws MessageHandlerException {
        SecurityParametersContext bearerSecurityParams = this.jwtBearerClientAuthSecurityParameters;
        if (bearerSecurityParams == null || bearerSecurityParams.getSignatureSigningParameters() == null) {
            throw new MessageHandlerException("Missing security parameters needed to sign private_key_jwt");
        }
        SignatureSigningParameters signatureSigningParameters = bearerSecurityParams.getSignatureSigningParameters();
        assert (signatureSigningParameters != null);
        if (signatureSigningParameters.getSigningCredential() == null) {
            throw new MessageHandlerException("Missing credential needed to sign private_key_jwt");
        }
        JWSAlgorithm jwsAlgorithm = new JWSAlgorithm(signatureSigningParameters.getSignatureAlgorithm());
        if (!JWSAlgorithm.Family.SIGNATURE.contains((Object)jwsAlgorithm)) {
            throw new MessageHandlerException("Trying to construct private_key_jwt using the wrong algorithm: " + String.valueOf(jwsAlgorithm));
        }
    }

    @Nonnull
    private JWTClaimsSet buildClientAuthenticationJwtClaims(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        String audience;
        if (this.profileConfiguration.isUseTargetedEndpointAsJWTAudience((ProfileRequestContext)PRC_LOOKUP.apply((BaseContext)messageContext))) {
            audience = this.providerMetadata.getTokenEndpointURI().toString();
        } else {
            OIDCPeerEntityContext localPeerEntityCtx = this.peerEntityContext;
            if (localPeerEntityCtx == null) {
                throw new MessageHandlerException("OIDC Peer entity context can not be null to use JWT based client authentication");
            }
            audience = localPeerEntityCtx.getIdentifier();
        }
        if (StringSupport.trimOrNull((String)audience) == null) {
            throw new MessageHandlerException("JWT audience can not be null");
        }
        JWTClaimsSet claimsSet = new JWTClaimsSet.Builder().subject(this.clientId).issuer(this.clientId).audience(audience).jwtID(OIDCProxySupport.generateNonce(32)).issueTime(Date.from(Instant.now())).expirationTime(Date.from(Instant.now().plus(this.jwtBearerExpiryOffset))).build();
        assert (claimsSet != null);
        return claimsSet;
    }

    @Nonnull
    private SignedJWT buildClientAuthenticationJwt(@Nonnull MessageContext messageContext) throws MessageHandlerException {
        SecurityParametersContext bearerSecurityParams = this.jwtBearerClientAuthSecurityParameters;
        if (bearerSecurityParams == null) {
            throw new MessageHandlerException("Requested client_secret_jwt client authentication, but signing parameters context could not be found");
        }
        SignatureSigningParameters signingParams = bearerSecurityParams.getSignatureSigningParameters();
        if (signingParams == null) {
            throw new MessageHandlerException("Requested client_secret_jwt client authentication, but signing parameters could not be found");
        }
        JWTClaimsSet claims = this.buildClientAuthenticationJwtClaims(messageContext);
        String jwtType = this.profileConfiguration.getClientAuthenticationJWTType((ProfileRequestContext)PRC_LOOKUP.apply((BaseContext)messageContext));
        if (jwtType == null) {
            jwtType = JOSEObjectType.JWT.getType();
        }
        try {
            JWSTokenSigner signer = new JWSTokenSigner(signingParams);
            SignedJWT signed = signer.sign(claims, jwtType);
            if (this.log.isDebugEnabled() && !this.log.isTraceEnabled()) {
                this.log.debug("{} Signed JWT Bearer Token for client authentication'", (Object)this.getLogPrefix());
            } else if (this.log.isTraceEnabled()) {
                this.log.trace("{} Signed JWT Bearer Token for client authentication: {}", (Object)this.getLogPrefix(), (Object)signed.serialize());
            }
            return signed;
        }
        catch (SignatureException e) {
            throw new MessageHandlerException((Exception)((Object)e));
        }
    }
}

