/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.oidc.authn.context.OAuth2ClientAuthenticationContext;
import net.shibboleth.oidc.profile.messaging.context.OIDCPeerEntityContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.handler.AbstractMessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.slf4j.Logger;

public class InitializeOAuth2ClientAuthenticationContext
extends AbstractMessageHandler {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(InitializeOAuth2ClientAuthenticationContext.class);
    @Nonnull
    private Function<MessageContext, OAuth2ClientAuthenticationContext> oauth2ClientAuthenticationContextLookupStrategy = new ChildContextLookup(OAuth2ClientAuthenticationContext.class, true).compose((Function)new ChildContextLookup(OIDCPeerEntityContext.class));

    public void setOAuth2ClientAuthenticationContextLookupStrategy(@Nonnull Function<MessageContext, OAuth2ClientAuthenticationContext> strgy) {
        this.checkSetterPreconditions();
        this.oauth2ClientAuthenticationContextLookupStrategy = (Function)Constraint.isNotNull(strgy, (String)"OAuth2 client authentication context lookup strategy cannot be null");
    }

    protected void doInvoke(MessageContext messageContext) throws MessageHandlerException {
        OAuth2ClientAuthenticationContext context = this.oauth2ClientAuthenticationContextLookupStrategy.apply(messageContext);
        if (context == null) {
            throw new MessageHandlerException("No OAuth2 client authentication context found or created");
        }
        this.log.debug("{} Initialized OAuth2 Client Authentication Context", (Object)this.getLogPrefix());
    }
}

