/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AbstractAuthenticatableOIDCContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AccessTokenResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.exception.OIDCRPException;
import net.shibboleth.idp.plugin.authn.oidc.rp.impl.AbstractHttpOIDCAuthenticationAction;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class ExchangeCodeForAccessToken
extends AbstractHttpOIDCAuthenticationAction<TokenResponse> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(ExchangeCodeForAccessToken.class);
    @Nonnull
    private Function<ProfileRequestContext, AccessTokenResponseContext> tokenResponseContextLookupStrategy = new ChildContextLookup(AccessTokenResponseContext.class, true).compose((Function)new InboundMessageContextLookup());

    public void setTokenResponseContextLookupStrategy(@Nonnull Function<ProfileRequestContext, AccessTokenResponseContext> strategy) {
        this.checkSetterPreconditions();
        this.tokenResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TokenResponseContext lookup strategy cannot be null");
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        AuthenticationSuccessResponse response = this.getAuthenticationResponse();
        if (response == null) {
            this.log.debug("{} No AuthenticationSuccessResponse found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        this.log.debug("{} Exchanging auth_code '{}' for id_token from provider '{}'", new Object[]{this.getLogPrefix(), response.getAuthorizationCode(), authenticationContext.getAuthenticatingAuthority()});
        AccessTokenResponseContext responseCtx = this.tokenResponseContextLookupStrategy.apply(profileRequestContext);
        if (responseCtx == null) {
            this.log.debug("{} No TokenResponseContext returned by lookup strategy", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return;
        }
        try {
            TokenResponse responseObject = (TokenResponse)this.handleRequest(profileRequestContext, (AbstractAuthenticatableOIDCContext)responseCtx);
            if (!(responseObject instanceof OIDCTokenResponse)) {
                throw new OIDCRPException("Token response was not of the expected format, expected OIDC token response, got " + responseObject.getClass().getSimpleName());
            }
            OIDCTokenResponse tokenResponse = (OIDCTokenResponse)responseObject;
            responseCtx.setTokenResponse(tokenResponse);
            this.log.trace("{} Token request response was successful '{}'", (Object)this.getLogPrefix(), (Object)tokenResponse.indicatesSuccess());
        }
        catch (OIDCRPException e) {
            this.log.error("{} Failed to exchange authorisation code for token result", (Object)this.getLogPrefix(), (Object)e);
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"AuthenticationException");
        }
    }
}

