/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.oauth2.sdk.ResponseMode;
import com.nimbusds.oauth2.sdk.id.Audience;
import com.nimbusds.oauth2.sdk.id.Identifier;
import com.nimbusds.oauth2.sdk.id.Issuer;
import com.nimbusds.openid.connect.sdk.claims.ClaimsSet;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.time.Duration;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.profile.AbstractProfileAction;
import net.shibboleth.oidc.metadata.context.OIDCProviderMetadataContext;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.oidc.profile.encoding.AuthenticationContextClassReferenceSupport;
import net.shibboleth.oidc.profile.messaging.context.OIDCPeerEntityContext;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.shared.annotation.constraint.NonnullBeforeExec;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.logic.PredicateSupport;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public class BuildRequestObject
extends AbstractProfileAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(BuildRequestObject.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCProviderMetadataContext> providerMetadataLookupStrategy;
    @Nonnull
    private Function<ProfileRequestContext, RelyingPartyContext> relyingPartyContextLookupStrategy;
    @Nonnull
    private Predicate<ClaimsSet> claimsSetIsValidPredicate = PredicateSupport.alwaysTrue();
    @Nonnull
    private BiConsumer<ProfileRequestContext, ClaimsSet> customClaimsStrategy;
    @Nonnull
    private Predicate<ProfileRequestContext> requestObjectToBeSignedPredicate = PredicateSupport.alwaysTrue();
    @NonnullBeforeExec
    private OIDCAuthenticationRequest authnRequest;
    @NonnullBeforeExec
    private OIDCProviderMetadata providerMetadata;

    public BuildRequestObject() {
        this.providerMetadataLookupStrategy = new ChildContextLookup(OIDCProviderMetadataContext.class).compose(new ChildContextLookup(OIDCPeerEntityContext.class).compose((Function)new OutboundMessageContextLookup()));
        this.relyingPartyContextLookupStrategy = new ChildContextLookup(RelyingPartyContext.class);
        this.customClaimsStrategy = (prc, set) -> {};
    }

    public void setCustomClaimsStrategy(@Nullable BiConsumer<ProfileRequestContext, ClaimsSet> strategy) {
        this.checkSetterPreconditions();
        if (strategy != null) {
            this.customClaimsStrategy = strategy;
        }
    }

    public void setRelyingPartyContextLookupStrategy(@Nonnull Function<ProfileRequestContext, RelyingPartyContext> strategy) {
        this.checkSetterPreconditions();
        this.relyingPartyContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"RelyingPartyContext lookup strategy cannot be null");
    }

    public void setProviderMetadataLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCProviderMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.providerMetadataLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Provider metadata lookup strategy can not be null");
    }

    public void setClaimsSetIsValidPredicate(@Nullable Predicate<ClaimsSet> predicate) {
        this.checkSetterPreconditions();
        if (predicate != null) {
            this.claimsSetIsValidPredicate = predicate;
        }
    }

    public void setRequestObjectToBeSignedPredicate(@Nullable Predicate<ProfileRequestContext> predicate) {
        this.checkSetterPreconditions();
        if (predicate != null) {
            this.requestObjectToBeSignedPredicate = predicate;
        }
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        if (!super.doPreExecute(profileRequestContext)) {
            return false;
        }
        MessageContext outboundMsgContext = profileRequestContext.getOutboundMessageContext();
        if (outboundMsgContext == null) {
            this.log.error("{} Outbound message context was null", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (!(outboundMsgContext.getMessage() instanceof OIDCAuthenticationRequest)) {
            this.log.error("{} Outbound message was not an authentication request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.authnRequest = (OIDCAuthenticationRequest)outboundMsgContext.getMessage();
        if (this.authnRequest == null) {
            this.log.error("{} No authentication request found", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        OIDCProviderMetadataContext providerMetadataContext = this.providerMetadataLookupStrategy.apply(profileRequestContext);
        if (providerMetadataContext == null) {
            this.log.error("{} No provider metadata context found for peer", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        this.providerMetadata = providerMetadataContext.getProviderInformation();
        if (this.providerMetadata == null) {
            this.log.error("{} No provider metadata found for peer", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidProfileContext");
            return false;
        }
        return true;
    }

    protected void doExecute(@Nonnull ProfileRequestContext profileRequestContext) {
        this.log.debug("{} Building a plain RequestObject JWT", (Object)this.getLogPrefix());
        ClaimsSet requestObjectClaims = new ClaimsSet();
        if (this.requestObjectToBeSignedPredicate.test(profileRequestContext)) {
            if (this.providerMetadata.getIssuer() == null) {
                this.log.error("{} Signed RequestObject requires 'iss' claim, which is currently null", (Object)this.getLogPrefix());
                ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
                return;
            }
            requestObjectClaims.setAudience(new Audience(this.providerMetadata.getIssuer().getValue()));
            requestObjectClaims.setIssuer(new Issuer(this.authnRequest.getClientID().getValue()));
        }
        requestObjectClaims.setClaim("client_id", (Object)this.authnRequest.getClientID().toString());
        this.setClaimIfPresent(requestObjectClaims, "nonce", this.authnRequest.getNonce());
        this.setClaimIfPresent(requestObjectClaims, "response_type", this.authnRequest.getResponseType());
        ResponseMode responseMode = this.authnRequest.getDefaultResponseMode();
        if (responseMode != null && !responseMode.equals((Object)this.authnRequest.getResponseMode())) {
            requestObjectClaims.setClaim("response_mode", (Object)this.authnRequest.getResponseMode());
        }
        this.setClaimIfPresent(requestObjectClaims, "redirect_uri", this.authnRequest.getRedirectURI());
        this.setClaimIfPresent(requestObjectClaims, "scope", this.authnRequest.getScope());
        this.setClaimIfPresent(requestObjectClaims, "max_age", this.authnRequest.getMaxAge());
        this.setClaimIfPresent(requestObjectClaims, "login_hint", this.authnRequest.getLoginHint());
        this.setClaimIfPresent(requestObjectClaims, "prompt", this.authnRequest.getPrompt());
        this.setClaimIfPresent(requestObjectClaims, "display", this.authnRequest.getDisplay());
        if (this.authnRequest.providerSupportsClaimsParameter()) {
            AuthenticationContextClassReferenceSupport.buildACRClaimsRequest((OIDCAuthenticationRequest)this.authnRequest);
            if (this.authnRequest.getRequestedClaims() != null) {
                requestObjectClaims.setClaim("claims", (Object)this.authnRequest.getRequestedClaims());
            }
        } else if (!this.authnRequest.getAcrs().isEmpty()) {
            String acrString = String.join((CharSequence)" ", this.authnRequest.getAcrs().stream().map(Identifier::getValue).toList());
            requestObjectClaims.setClaim("acr_values", (Object)acrString);
        }
        this.customClaimsStrategy.accept(profileRequestContext, requestObjectClaims);
        if (!this.validateRequestObject(profileRequestContext, requestObjectClaims)) {
            this.log.error("{} RequestObject claims are not valid", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidAuthenticationContext");
            return;
        }
        if (this.log.isDebugEnabled()) {
            this.log.debug("{} Setting the RequestObject claims: {}", (Object)this.getLogPrefix(), (Object)requestObjectClaims.toJSONString());
        }
        this.authnRequest.setRequestObjectClaimsSet(requestObjectClaims);
    }

    private void setClaimIfPresent(@Nonnull ClaimsSet claims, @Nonnull String claimName, @Nullable Object claim) {
        if (claim instanceof Duration) {
            Duration duration = (Duration)claim;
            claims.setClaim(claimName, (Object)duration.toSeconds());
        } else if (claim != null) {
            claims.setClaim(claimName, (Object)claim.toString());
        }
    }

    private boolean validateRequestObject(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull ClaimsSet requestObjectClaims) {
        if (!this.claimsSetIsValidPredicate.test(requestObjectClaims)) {
            return false;
        }
        if (this.requestObjectToBeSignedPredicate.test(profileRequestContext)) {
            if (requestObjectClaims.getClaim("iss") == null) {
                return false;
            }
            if (requestObjectClaims.getClaim("aud") == null) {
                return false;
            }
        }
        return true;
    }
}

