/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.oauth2.sdk.ResponseMode;
import jakarta.servlet.ServletException;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.authn.ExternalAuthentication;
import net.shibboleth.idp.authn.ExternalAuthenticationException;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.OIDCAuthnContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.OutboundMessageHandlerContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.exception.OIDCProxyException;
import net.shibboleth.idp.plugin.authn.oidc.rp.impl.OIDCProxySupport;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.component.AbstractInitializableComponent;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.messaging.decoder.MessageDecoder;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.profile.context.EventContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@RequestMapping(value={"%{idp.authn.oidc.rp.externalAuthnPath:/Authn/OIDC/RP}"})
@ThreadSafe
public class AuthorizationController
extends AbstractInitializableComponent {
    @Nonnull
    @NotEmpty
    public static final String AUTHORIZE_PATH_SEGMENT = "/authz";
    @Nonnull
    @NotEmpty
    public static final String CALLBACK_PATH_SEGMENT = "/callback";
    @Nonnull
    @NotEmpty
    public static final String CODE_PARAMETER = "code";
    @Nonnull
    @NotEmpty
    public static final String STATE_PARAMETER = "state";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AuthorizationController.class);
    @Nonnull
    private Function<ProfileRequestContext, ProfileRequestContext> profileRequestContextLookupStrategy = new ChildContextLookup(ProfileRequestContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));
    @Nonnull
    private Function<ProfileRequestContext, OIDCAuthnContext> oidcContextLookupStrategy = new ChildContextLookup(OIDCAuthnContext.class).compose((Function)new ChildContextLookup(AuthenticationContext.class));

    public void setProfileRequestContextLookupStrategy(@Nonnull Function<ProfileRequestContext, ProfileRequestContext> strategy) {
        this.checkSetterPreconditions();
        this.profileRequestContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"ProfileRequestContext lookup strategy cannot be null");
    }

    public void setOidcAuthnContextLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCAuthnContext> strategy) {
        this.checkSetterPreconditions();
        this.oidcContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"OIDCAuthnContext lookup strategy cannot be null");
    }

    @GetMapping(value={"/authz"})
    public void authorizationRequest(@Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse) throws ServletException, IOException, ExternalAuthenticationException {
        String key = ExternalAuthentication.startExternalAuthentication((HttpServletRequest)httpRequest);
        ProfileRequestContext prc = ExternalAuthentication.getProfileRequestContext((String)key, (HttpServletRequest)httpRequest);
        OIDCAuthnContext oidcContext = this.oidcContextLookupStrategy.apply(prc);
        if (oidcContext == null) {
            this.log.error("OIDCAuthnContext not found");
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        ProfileRequestContext nestedPRC = this.profileRequestContextLookupStrategy.apply(prc);
        if (nestedPRC == null) {
            this.log.error("Nested ProfileRequestContext not found");
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        MessageContext outMsgContext = nestedPRC.getOutboundMessageContext();
        if (outMsgContext == null || !(outMsgContext.getMessage() instanceof OIDCAuthenticationRequest)) {
            this.log.error("Outbound Authorization message not found");
            httpRequest.setAttribute("authnError", (Object)"InvalidMessage");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        outMsgContext.addSubcontext((BaseContext)new OutboundMessageHandlerContext(key));
        try {
            Object event;
            MessageHandler handler = oidcContext.getOutboundMessageHandler();
            if (handler != null) {
                handler.invoke(outMsgContext);
            }
            this.log.debug("OIDC Relying Party Proxy executing message encoders to make upstream request to OpenID Provider");
            oidcContext.getEncodeMessageAction().execute(nestedPRC);
            EventContext eventCtx = (EventContext)nestedPRC.getSubcontext(EventContext.class);
            Object object = event = eventCtx != null ? eventCtx.getEvent() : null;
            if (eventCtx != null && event != null && !"proceed".equals(eventCtx.getEvent())) {
                this.log.error("Message encoding action signaled non-proceed event {}", event);
                httpRequest.setAttribute("authnError", (Object)event.toString());
                ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
                return;
            }
        }
        catch (MessageHandlerException e) {
            this.log.error("Caught message handling exception", (Throwable)e);
            httpRequest.setAttribute("authnError", (Object)"MessageProcessingError");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequestMapping(value={"/callback"})
    public void authorizationCallback(@Nonnull HttpServletRequest httpRequest, @Nonnull HttpServletResponse httpResponse) throws ExternalAuthenticationException, IOException {
        Object object;
        String key;
        String state = httpRequest.getParameter(STATE_PARAMETER);
        this.log.debug("OIDC Relying Party Proxy recieved callback with state '{}'", (Object)state);
        if (state == null) {
            throw new ExternalAuthenticationException("OIDC authentication response must contain a 'state' parameter");
        }
        try {
            key = OIDCProxySupport.extractKeyFromState(state);
        }
        catch (OIDCProxyException e) {
            throw new ExternalAuthenticationException("Flow execution key component could not be found in the returned state, unable to resume the flow execution", (Exception)((Object)e));
        }
        ProfileRequestContext prc = ExternalAuthentication.getProfileRequestContext((String)key, (HttpServletRequest)httpRequest);
        OIDCAuthnContext oidcContext = this.oidcContextLookupStrategy.apply(prc);
        if (oidcContext == null) {
            this.log.error("OIDCAuthnContext not found");
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        ProfileRequestContext nestedPRC = this.profileRequestContextLookupStrategy.apply(prc);
        if (nestedPRC == null) {
            this.log.error("Nested ProfileRequestContext not found");
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        OIDCAuthenticationRequest authnRequest = null;
        MessageContext outMsgContext = nestedPRC.getOutboundMessageContext();
        if (outMsgContext != null && (object = outMsgContext.getMessage()) instanceof OIDCAuthenticationRequest) {
            OIDCAuthenticationRequest authenticationRequest;
            authnRequest = authenticationRequest = (OIDCAuthenticationRequest)object;
        }
        if (authnRequest == null) {
            this.log.error("Authentication request not found in context, cannot decode incomming request");
            httpRequest.setAttribute("authnError", (Object)"InvalidProfileContext");
            ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
            return;
        }
        this.log.debug("OIDC response_type '{}' and response_mode '{}' requested, decoding incoming request", (Object)authnRequest.getResponseType(), (Object)authnRequest.getResponseMode());
        try {
            ResponseMode responseMode = authnRequest.getResponseMode();
            if (responseMode == null) {
                throw new MessageDecodingException("Unable to obtain response_mode to decode incomming request");
            }
            MessageDecoder decoder = (MessageDecoder)oidcContext.getMessageDecoderFactory().apply(responseMode.getValue());
            if (decoder == null) {
                throw new MessageDecodingException("Unable to obtain MessageDecoder for response_mode: " + responseMode.getValue());
            }
            try {
                decoder.initialize();
                decoder.decode();
                MessageContext messageContext = decoder.getMessageContext();
                nestedPRC.setInboundMessageContext(messageContext);
            }
            finally {
                decoder.destroy();
            }
        }
        catch (ComponentInitializationException | MessageDecodingException e) {
            this.log.error("Unable to decode OIDC response", e);
            httpRequest.setAttribute("authnError", (Object)"UnableToDecode");
        }
        ExternalAuthentication.finishExternalAuthentication((String)key, (HttpServletRequest)httpRequest, (HttpServletResponse)httpResponse);
    }
}

