/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.oauth2.sdk.token.AccessToken;
import com.nimbusds.oauth2.sdk.token.RefreshToken;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import java.security.Principal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.function.Function;
import javax.annotation.Nonnull;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AccessTokenResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.principal.OAuth2AccessTokenPrincipal;
import net.shibboleth.idp.plugin.authn.oidc.rp.principal.OAuth2RefreshTokenPrincipal;
import net.shibboleth.shared.collection.CollectionSupport;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;

public class AccessTokenToPrivateCredentialsMappingStrategy
implements Function<ProfileRequestContext, Collection<Principal>> {
    @Nonnull
    private final Function<ProfileRequestContext, AccessTokenResponseContext> tokenResponseContextLookupStrategy;

    public AccessTokenToPrivateCredentialsMappingStrategy(@Nonnull Function<ProfileRequestContext, AccessTokenResponseContext> strategy) {
        this.tokenResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"TokenResponseContext Lookup Strategy can not be null");
    }

    public AccessTokenToPrivateCredentialsMappingStrategy() {
        this.tokenResponseContextLookupStrategy = new ChildContextLookup(AccessTokenResponseContext.class, true).compose((Function)new InboundMessageContextLookup());
    }

    @Override
    public Collection<Principal> apply(ProfileRequestContext input) {
        OIDCTokenResponse tokenResponse;
        AccessTokenResponseContext context = this.tokenResponseContextLookupStrategy.apply(input);
        OIDCTokenResponse oIDCTokenResponse = tokenResponse = context != null ? context.getTokenResponse() : null;
        if (tokenResponse != null) {
            ArrayList<Principal> principals = new ArrayList<Principal>();
            AccessToken accessToken = tokenResponse.getTokens().getAccessToken();
            assert (accessToken != null);
            RefreshToken refreshToken = tokenResponse.getTokens().getRefreshToken();
            OAuth2AccessTokenPrincipal accessTokenPrincipal = new OAuth2AccessTokenPrincipal(accessToken.getValue(), accessToken.getType().getValue(), accessToken.getLifetime() == 0L ? null : Duration.ofSeconds(accessToken.getLifetime()));
            principals.add((Principal)accessTokenPrincipal);
            if (refreshToken != null) {
                OAuth2RefreshTokenPrincipal refreshTokenPrincipal = new OAuth2RefreshTokenPrincipal(refreshToken.getValue());
                principals.add((Principal)refreshTokenPrincipal);
            }
            return principals;
        }
        return CollectionSupport.emptyList();
    }
}

