/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.authn.AbstractAuthenticationAction;
import net.shibboleth.idp.authn.context.AuthenticationContext;
import net.shibboleth.oidc.metadata.context.OIDCProviderMetadataContext;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.oidc.profile.messaging.context.OIDCPeerEntityContext;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.action.ActionSupport;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.OutboundMessageContextLookup;
import org.slf4j.Logger;

public abstract class AbstractOIDCAuthenticationResponseAction
extends AbstractAuthenticationAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractOIDCAuthenticationResponseAction.class);
    @Nonnull
    private Function<ProfileRequestContext, OIDCProviderMetadataContext> providerMetadataLookupStrategy = new ChildContextLookup(OIDCProviderMetadataContext.class).compose(new ChildContextLookup(OIDCPeerEntityContext.class).compose((Function)new OutboundMessageContextLookup()));
    @Nullable
    private AuthenticationSuccessResponse authnResponse;
    @Nullable
    private OIDCAuthenticationRequest authnRequest;
    @Nullable
    private OIDCProviderMetadataContext providerMetadataContext;

    protected AbstractOIDCAuthenticationResponseAction() {
    }

    public void setProviderMetadataLookupStrategy(@Nonnull Function<ProfileRequestContext, OIDCProviderMetadataContext> strategy) {
        this.checkSetterPreconditions();
        this.providerMetadataLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"Provider metadata lookup strategy can not be null");
    }

    @Nullable
    protected AuthenticationSuccessResponse getAuthenticationResponse() {
        return this.authnResponse;
    }

    @Nullable
    protected OIDCAuthenticationRequest getAuthenticationRequest() {
        return this.authnRequest;
    }

    @Nullable
    protected OIDCProviderMetadataContext getProviderMetadataContext() {
        return this.providerMetadataContext;
    }

    protected boolean doPreExecute(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull AuthenticationContext authenticationContext) {
        if (!super.doPreExecute(profileRequestContext, authenticationContext)) {
            return false;
        }
        MessageContext inboundMessageCtx = profileRequestContext.getInboundMessageContext();
        if (inboundMessageCtx == null) {
            this.log.error("{} No inbound message context", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (inboundMessageCtx.getMessage() == null) {
            this.log.error("{} No inbound message", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (!(inboundMessageCtx.getMessage() instanceof AuthenticationSuccessResponse)) {
            this.log.error("{} No inbound authentication success response", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.authnResponse = (AuthenticationSuccessResponse)inboundMessageCtx.getMessage();
        MessageContext outboundMsgContext = profileRequestContext.getOutboundMessageContext();
        if (outboundMsgContext == null) {
            this.log.error("{} Outbound message context was null", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        if (!(outboundMsgContext.getMessage() instanceof OIDCAuthenticationRequest)) {
            this.log.error("{} Outbound message was not an authentication request", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        this.authnRequest = (OIDCAuthenticationRequest)outboundMsgContext.getMessage();
        this.providerMetadataContext = this.providerMetadataLookupStrategy.apply(profileRequestContext);
        if (this.providerMetadataContext == null) {
            this.log.error("{} No provider metadata found for peer", (Object)this.getLogPrefix());
            ActionSupport.buildEvent((ProfileRequestContext)profileRequestContext, (String)"InvalidMessageContext");
            return false;
        }
        return true;
    }
}

