/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.impl;

import com.nimbusds.oauth2.sdk.ErrorObject;
import com.nimbusds.oauth2.sdk.ErrorResponse;
import com.nimbusds.oauth2.sdk.Response;
import java.io.IOException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AbstractAuthenticatableOIDCContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.exception.OIDCRPException;
import net.shibboleth.idp.plugin.authn.oidc.rp.impl.AbstractOIDCAuthenticationResponseAction;
import net.shibboleth.shared.annotation.constraint.NonnullAfterInit;
import net.shibboleth.shared.annotation.constraint.ThreadSafeAfterInit;
import net.shibboleth.shared.component.ComponentInitializationException;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.client5.http.classic.HttpClient;
import org.apache.hc.client5.http.protocol.HttpClientContext;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.HttpRequest;
import org.apache.hc.core5.http.io.HttpClientResponseHandler;
import org.apache.hc.core5.http.protocol.HttpContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.slf4j.Logger;

@ThreadSafeAfterInit
public abstract class AbstractHttpOIDCAuthenticationAction<T extends Response>
extends AbstractOIDCAuthenticationResponseAction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(AbstractHttpOIDCAuthenticationAction.class);
    @NonnullAfterInit
    private Function<ProfileRequestContext, ClassicHttpRequest> httpRequestEncoderStrategy;
    @NonnullAfterInit
    private HttpClientResponseHandler<T> httpResponseDecoderStrategy;
    @NonnullAfterInit
    private HttpClient httpClient;
    @Nullable
    private HttpClientSecurityParameters httpClientSecurityParameters;

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.httpClient == null) {
            throw new ComponentInitializationException("httpClient cannot be null");
        }
        if (this.httpRequestEncoderStrategy == null) {
            throw new ComponentInitializationException("HTTP request encoder strategy cannot be null");
        }
        if (this.httpResponseDecoderStrategy == null) {
            throw new ComponentInitializationException("HTTP response decoder strategy cannot be null");
        }
    }

    @NonnullAfterInit
    public Function<ProfileRequestContext, ClassicHttpRequest> getHttpRequestEncoderStrategy() {
        return this.httpRequestEncoderStrategy;
    }

    @NonnullAfterInit
    public HttpClientResponseHandler<T> getHttpResponseDecoderStrategy() {
        return this.httpResponseDecoderStrategy;
    }

    public void setHttpResponseDecoderStrategy(@Nonnull HttpClientResponseHandler<T> strategy) {
        this.checkSetterPreconditions();
        this.httpResponseDecoderStrategy = (HttpClientResponseHandler)Constraint.isNotNull(strategy, (String)"Http decoder strategy can not be null");
    }

    public void setHttpRequestEncoderStrategy(@Nonnull Function<ProfileRequestContext, ClassicHttpRequest> strategy) {
        this.checkSetterPreconditions();
        this.httpRequestEncoderStrategy = (Function)Constraint.isNotNull(strategy, (String)"Http encoder strategy can not be null");
    }

    public void setHttpClient(@Nonnull HttpClient client) {
        this.checkSetterPreconditions();
        this.httpClient = (HttpClient)Constraint.isNotNull((Object)client, (String)"HttpClient cannot be null");
    }

    public void setHttpClientSecurityParameters(@Nullable HttpClientSecurityParameters params) {
        this.checkSetterPreconditions();
        this.httpClientSecurityParameters = params;
    }

    @Nonnull
    protected T handleRequest(@Nonnull ProfileRequestContext profileRequestContext, @Nullable AbstractAuthenticatableOIDCContext authenticatableContext) throws OIDCRPException {
        try {
            ClassicHttpRequest request = this.getHttpRequestEncoderStrategy().apply(profileRequestContext);
            if (request == null) {
                throw new OIDCRPException("Unable to encode HTTP request");
            }
            T response = this.executeHttpRequest(request, authenticatableContext);
            if (response == null) {
                throw new OIDCRPException("Unable to process HTTP response");
            }
            if (!response.indicatesSuccess()) {
                throw new OIDCRPException(this.formatErrorResponse(((ErrorResponse)response).getErrorObject()));
            }
            return response;
        }
        catch (IOException e) {
            this.log.error("{} Unable to perform HTTP request and return response", (Object)this.getLogPrefix(), (Object)e);
            throw new OIDCRPException((Throwable)e);
        }
    }

    private String formatErrorResponse(@Nullable ErrorObject error) {
        StringBuilder errorMsg = new StringBuilder();
        if (error == null) {
            errorMsg.append("Unknown error");
            return errorMsg.toString();
        }
        errorMsg.append("Error response, HTTP status code '").append(error.getHTTPStatusCode()).append("', error code '").append(error.getCode()).append("', description: ").append(error.getDescription());
        return errorMsg.toString();
    }

    @Nullable
    protected T executeHttpRequest(@Nonnull ClassicHttpRequest request, @Nullable AbstractAuthenticatableOIDCContext authenticatableContext) throws IOException {
        Constraint.isNotNull((Object)request, (String)"Request can not be null");
        HttpClientContext clientContext = HttpClientContext.create();
        assert (clientContext != null);
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)clientContext, (HttpClientSecurityParameters)this.httpClientSecurityParameters, (boolean)true);
        HttpClientSecuritySupport.addDefaultTLSTrustEngineCriteria((HttpClientContext)clientContext, (HttpRequest)request);
        Response httpResponse = (Response)this.httpClient.execute(request, (HttpContext)clientContext, this.httpResponseDecoderStrategy);
        String scheme = request.getScheme();
        assert (scheme != null);
        HttpClientSecuritySupport.checkTLSCredentialEvaluated((HttpClientContext)clientContext, (String)scheme);
        if (authenticatableContext != null) {
            authenticatableContext.setAuthenticated(true);
        }
        return (T)httpResponse;
    }
}

