/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.encoding.impl;

import com.nimbusds.jose.util.StandardCharset;
import com.nimbusds.oauth2.sdk.token.BearerAccessToken;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import java.net.URI;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.oidc.rp.config.navigate.UserInfoHttpRequestMethodLookupStrategy;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AccessTokenResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.encoding.impl.AbstractRequestEncoderFunction;
import net.shibboleth.idp.plugin.authn.oidc.rp.exception.OIDCRPException;
import net.shibboleth.oidc.profile.oauth2.config.OAuth2AuthorizationProfileConfiguration;
import net.shibboleth.shared.annotation.constraint.NotEmpty;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.apache.hc.core5.net.URIBuilder;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;
import org.slf4j.Logger;

public class DefaultUserInfoRequestEncoder
extends AbstractRequestEncoderFunction {
    @Nonnull
    @NotEmpty
    private static final String HTTPS = "https";
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultUserInfoRequestEncoder.class);
    @Nonnull
    private Function<ProfileRequestContext, AccessTokenResponseContext> tokenResponseContextLookupStrategy = new ChildContextLookup(AccessTokenResponseContext.class, true).compose((Function)new InboundMessageContextLookup());
    @Nonnull
    private Function<ProfileRequestContext, OAuth2AuthorizationProfileConfiguration.HttpRequestMethod> httpMethodLookupStrategy = new UserInfoHttpRequestMethodLookupStrategy();

    public void setTokenResponseContextLookupStrategy(Function<ProfileRequestContext, AccessTokenResponseContext> strategy) {
        this.checkSetterPreconditions();
        this.tokenResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"tokenResponseContextLookupStrategy can not be null");
    }

    public void setHttpMethodLookupStrategy(Function<ProfileRequestContext, OAuth2AuthorizationProfileConfiguration.HttpRequestMethod> strategy) {
        this.checkSetterPreconditions();
        this.httpMethodLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"httpMethodLookupStrategy can not be null");
    }

    @Override
    @Nullable
    public ClassicHttpRequest doApply(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull OIDCProviderMetadata providerMetadata) {
        try {
            OAuth2AuthorizationProfileConfiguration.HttpRequestMethod requestMethod = this.httpMethodLookupStrategy.apply(profileRequestContext);
            AccessTokenResponseContext responseCtx = this.tokenResponseContextLookupStrategy.apply(profileRequestContext);
            if (responseCtx == null) {
                this.log.debug("No TokenResponseContext returned by lookup strategy");
                return null;
            }
            URI uri = new URIBuilder().setScheme(HTTPS).setPort(providerMetadata.getUserInfoEndpointURI().getPort()).setHost(providerMetadata.getUserInfoEndpointURI().getHost()).setPath(providerMetadata.getUserInfoEndpointURI().getPath()).build();
            ClassicRequestBuilder rb = null;
            if (requestMethod == OAuth2AuthorizationProfileConfiguration.HttpRequestMethod.GET) {
                rb = ClassicRequestBuilder.get().setUri(uri).setHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.getMimeType()).setCharset(StandardCharset.UTF_8);
                assert (rb != null);
                this.addBearerTokenToGet(rb, responseCtx);
            } else if (requestMethod == OAuth2AuthorizationProfileConfiguration.HttpRequestMethod.POST) {
                rb = ClassicRequestBuilder.post().setUri(uri).setHeader("Content-Type", ContentType.APPLICATION_FORM_URLENCODED.getMimeType()).setCharset(StandardCharset.UTF_8);
                assert (rb != null);
                this.addBearerTokenToPost(rb, responseCtx);
            } else {
                this.log.error("Unable to construct UserInfo request, unknown request method: {}", (Object)requestMethod);
                return null;
            }
            ClassicHttpRequest request = rb.build();
            this.log.debug("UserInfo request URL '{}'", (Object)request);
            return request;
        }
        catch (Exception e) {
            this.log.warn("Unable to encode token request", (Throwable)e);
            return null;
        }
    }

    private void addBearerTokenToPost(@Nonnull ClassicRequestBuilder rb, @Nonnull AccessTokenResponseContext responseCtx) throws OIDCRPException {
        OIDCTokenResponse tokenResponse = responseCtx.getTokenResponse();
        if (tokenResponse == null) {
            throw new OIDCRPException("No access token response found");
        }
        BearerAccessToken bearer = tokenResponse.getTokens().getBearerAccessToken();
        if (bearer == null) {
            throw new OIDCRPException("Access token was not Bearer type");
        }
        rb.addParameter("access_token", bearer.getValue());
    }

    private void addBearerTokenToGet(@Nonnull ClassicRequestBuilder rb, @Nonnull AccessTokenResponseContext responseCtx) throws OIDCRPException {
        OIDCTokenResponse tokenResponse = responseCtx.getTokenResponse();
        if (tokenResponse == null) {
            throw new OIDCRPException("No access token response found");
        }
        BearerAccessToken bearer = tokenResponse.getTokens().getBearerAccessToken();
        if (bearer == null) {
            throw new OIDCRPException("Access token was not Bearer type");
        }
        rb.addHeader("Authorization", bearer.toAuthorizationHeader());
    }
}

