/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.encoding.impl;

import com.nimbusds.jose.util.StandardCharset;
import com.nimbusds.oauth2.sdk.AuthorizationCodeGrant;
import com.nimbusds.oauth2.sdk.AuthorizationGrant;
import com.nimbusds.oauth2.sdk.TokenRequest;
import com.nimbusds.oauth2.sdk.http.HTTPRequest;
import com.nimbusds.oauth2.sdk.pkce.CodeVerifier;
import com.nimbusds.openid.connect.sdk.AuthenticationSuccessResponse;
import com.nimbusds.openid.connect.sdk.op.OIDCProviderMetadata;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.oidc.rp.encoding.impl.AbstractRequestEncoderFunction;
import net.shibboleth.oidc.authn.context.OAuth2ClientAuthenticationContext;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.core5.http.ClassicHttpRequest;
import org.apache.hc.core5.http.io.support.ClassicRequestBuilder;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

public class DefaultAuthCodeTokenRequestEncoder
extends AbstractRequestEncoderFunction {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultAuthCodeTokenRequestEncoder.class);

    @Override
    @Nullable
    public ClassicHttpRequest doApply(@Nonnull ProfileRequestContext profileRequestContext, @Nonnull OIDCProviderMetadata providerMetadata) {
        try {
            OAuth2ClientAuthenticationContext authnContext = this.getClientAuthenticationContext();
            if (authnContext == null) {
                this.log.warn("No client authentication context to base token request off");
                return null;
            }
            AuthenticationSuccessResponse authnResponse = this.getAuthenticationResponse();
            if (authnResponse == null) {
                this.log.warn("No authentication response from upstream OpenID Provider to base token request off");
                return null;
            }
            OIDCAuthenticationRequest authnRequest = this.getAuthenticationRequest();
            if (authnRequest == null) {
                this.log.warn("No authentication request to base token request off");
                return null;
            }
            AuthorizationCodeGrant codeGrant = new AuthorizationCodeGrant(authnResponse.getAuthorizationCode(), authnRequest.getRedirectURI(), authnRequest.getCodeVerifier() != null ? new CodeVerifier(authnRequest.getCodeVerifier()) : null);
            TokenRequest tokenRequest = new TokenRequest(providerMetadata.getTokenEndpointURI(), authnContext.getClientAuthentication(), (AuthorizationGrant)codeGrant);
            HTTPRequest httpRequest = tokenRequest.toHTTPRequest();
            assert (httpRequest != null);
            return this.convertHttpRequest(httpRequest);
        }
        catch (Exception e) {
            this.log.warn("Unable to encode token request", (Throwable)e);
            return null;
        }
    }

    @Nullable
    private ClassicHttpRequest convertHttpRequest(@Nonnull HTTPRequest request) {
        if (request.getMethod() != HTTPRequest.Method.POST) {
            this.log.warn("Token Request must use the HTTP POST method, is trying to use '{}'", (Object)request.getMethod());
            return null;
        }
        ClassicRequestBuilder rb = ClassicRequestBuilder.post().setUri(request.getURI()).setHeader("Content-Type", request.getEntityContentType().toString()).setCharset(StandardCharset.UTF_8);
        request.getQueryParameters().forEach((k, v) -> v.stream().forEach(value -> rb.addParameter(k, value)));
        if (request.getAuthorization() != null && !request.getAuthorization().isEmpty()) {
            rb.addHeader("Authorization", request.getAuthorization());
        }
        return rb.build();
    }
}

