/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.decoding.impl;

import com.fasterxml.jackson.core.type.TypeReference;
import com.nimbusds.oauth2.sdk.TokenErrorResponse;
import com.nimbusds.oauth2.sdk.TokenResponse;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import java.io.IOException;
import java.io.InputStream;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minidev.json.JSONObject;
import net.shibboleth.idp.plugin.authn.oidc.rp.decoding.impl.AbstractJSONResponseDecoderFunction;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.apache.hc.core5.http.ClassicHttpResponse;
import org.apache.hc.core5.http.ContentType;
import org.apache.hc.core5.http.HttpEntity;
import org.apache.hc.core5.http.HttpException;
import org.slf4j.Logger;
import org.springframework.http.MediaType;
import org.springframework.util.MimeType;

public class DefaultAccessTokenResponseDecoder
extends AbstractJSONResponseDecoderFunction<TokenResponse> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(DefaultAccessTokenResponseDecoder.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TokenResponse handleResponse(ClassicHttpResponse httpResponse) throws HttpException, IOException {
        try {
            if (httpResponse == null) {
                this.log.warn("HttpResponse was null, can not process response");
                return null;
            }
            HttpEntity entity = httpResponse.getEntity();
            if (entity == null) {
                this.log.warn("HTTP response did not contain an entity");
                return null;
            }
            ContentType contentType = ContentType.parse((CharSequence)httpResponse.getEntity().getContentType());
            if (contentType == null || contentType.getMimeType() == null) {
                this.log.warn("HTTP response did not contain a content-type, must contain a content-type");
                return null;
            }
            String mimeType = contentType.getMimeType();
            assert (mimeType != null);
            if (MediaType.APPLICATION_JSON.compareTo(MimeType.valueOf((String)mimeType)) != 0) {
                this.log.warn("Wrong content type header, expected 'application/json' found '{}'", (Object)contentType.getMimeType());
                return null;
            }
            try (InputStream input = httpResponse.getEntity().getContent();){
                int httpStatusCode;
                if (input == null) {
                    this.log.warn("HTTP response does not contain a message entity, nothing to decode");
                    TokenResponse tokenResponse = null;
                    return tokenResponse;
                }
                Map tokenResponseAsMap = (Map)this.getObjectMapper().readValue(input, (TypeReference)new TypeReference<Map<String, Object>>(){});
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Token Response: {}", (Object)tokenResponseAsMap);
                }
                if ((httpStatusCode = httpResponse.getCode()) != 200) {
                    TokenErrorResponse tokenErrorResponse = TokenErrorResponse.parse((JSONObject)new JSONObject(tokenResponseAsMap));
                    return tokenErrorResponse;
                }
                OIDCTokenResponse oIDCTokenResponse = OIDCTokenResponse.parse((JSONObject)new JSONObject(tokenResponseAsMap));
                return oIDCTokenResponse;
            }
        }
        catch (Exception e) {
            this.log.warn("Unable to decode response", (Throwable)e);
            return null;
        }
    }
}

