/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.context.navigate;

import com.nimbusds.jwt.JWT;
import com.nimbusds.jwt.JWTClaimsSet;
import java.text.ParseException;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.core.OIDCAuthenticationRequest;
import net.shibboleth.shared.logic.Constraint;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.MessageContext;
import org.slf4j.Logger;

public class JWTClaimsSetFromRequestObjectLookupFunction
implements Function<MessageContext, JWTClaimsSet> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JWTClaimsSetFromRequestObjectLookupFunction.class);
    @Nonnull
    private Function<MessageContext, OIDCAuthenticationRequest> authenticationRequestLookupStrategy = mc -> {
        Object patt1980$temp = mc.getMessage();
        if (patt1980$temp instanceof OIDCAuthenticationRequest) {
            OIDCAuthenticationRequest request = (OIDCAuthenticationRequest)patt1980$temp;
            return request;
        }
        return null;
    };

    public void setAuthenticationRequestLookupStrategy(@Nonnull Function<MessageContext, OIDCAuthenticationRequest> strategy) {
        this.authenticationRequestLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"AuthenticationRequestLookupStrategy lookup strategy cannot be null");
    }

    @Override
    @Nullable
    public JWTClaimsSet apply(@Nullable MessageContext messageContext) {
        JWT requestObject;
        if (messageContext == null) {
            return null;
        }
        OIDCAuthenticationRequest authnRequest = this.authenticationRequestLookupStrategy.apply(messageContext);
        JWT jWT = requestObject = authnRequest != null ? authnRequest.getRequestObject() : null;
        if (requestObject == null) {
            return null;
        }
        try {
            return requestObject.getJWTClaimsSet();
        }
        catch (ParseException e) {
            this.log.debug("Error parsing JWT Claims Set of the RequestObject", (Throwable)e);
            return null;
        }
    }
}

