/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.context.logic;

import com.nimbusds.oauth2.sdk.auth.ClientAuthenticationMethod;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.oidc.profile.config.OIDCAuthenticationRelyingPartyProfileConfiguration;
import net.shibboleth.profile.config.ProfileConfiguration;
import net.shibboleth.profile.context.RelyingPartyContext;
import net.shibboleth.profile.context.logic.messaging.AbstractRelyingPartyPredicate;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.ParentProfileRequestContextLookup;
import org.slf4j.Logger;

public class JWTBearerTokenForClientAuthenticationPredicate
extends AbstractRelyingPartyPredicate {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(JWTBearerTokenForClientAuthenticationPredicate.class);

    public boolean test(@Nullable MessageContext input) {
        ProfileConfiguration pc;
        ParentProfileRequestContextLookup lookup = new ParentProfileRequestContextLookup();
        ProfileRequestContext prc = (ProfileRequestContext)lookup.apply((BaseContext)input);
        RelyingPartyContext rpc = (RelyingPartyContext)this.getRelyingPartyContextLookupStrategy().apply(input);
        if (rpc != null && (pc = rpc.getProfileConfig()) instanceof OIDCAuthenticationRelyingPartyProfileConfiguration) {
            OIDCAuthenticationRelyingPartyProfileConfiguration config = (OIDCAuthenticationRelyingPartyProfileConfiguration)pc;
            String authMethod = config.getTokenEndpointAuthMethod(prc);
            ClientAuthenticationMethod method = new ClientAuthenticationMethod(authMethod);
            if (method.equals((Object)ClientAuthenticationMethod.CLIENT_SECRET_JWT) || method.equals((Object)ClientAuthenticationMethod.PRIVATE_KEY_JWT)) {
                this.log.trace("Client authentication type requires key lookup, is '{}", (Object)method);
                return true;
            }
            this.log.trace("Configured client authentication method '{}' does not require a signed JWT bearer token", (Object)authMethod);
        }
        return false;
    }
}

