/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.messaging.context.logic;

import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.UserInfoResponseContext;
import net.shibboleth.shared.logic.Constraint;
import org.opensaml.messaging.context.navigate.ChildContextLookup;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.context.navigate.InboundMessageContextLookup;

public abstract class AbstractUserInfoResponseTypeCondition
implements Predicate<ProfileRequestContext> {
    @Nonnull
    private final Function<ProfileRequestContext, UserInfoResponseContext> userInfoResponseContextLookupStrategy;

    protected AbstractUserInfoResponseTypeCondition() {
        this.userInfoResponseContextLookupStrategy = new ChildContextLookup(UserInfoResponseContext.class).compose((Function)new InboundMessageContextLookup());
    }

    protected AbstractUserInfoResponseTypeCondition(@Nonnull Function<ProfileRequestContext, UserInfoResponseContext> strategy) {
        this.userInfoResponseContextLookupStrategy = (Function)Constraint.isNotNull(strategy, (String)"UserInfoResponseContext lookup strategy can not be null");
    }

    @Override
    public boolean test(@Nullable ProfileRequestContext prc) {
        if (prc == null) {
            return false;
        }
        UserInfoResponseContext context = this.userInfoResponseContextLookupStrategy.apply(prc);
        if (context == null) {
            return false;
        }
        return this.doTest(prc, context);
    }

    protected abstract boolean doTest(@Nonnull ProfileRequestContext var1, @Nonnull UserInfoResponseContext var2);
}

