/*
 * Decompiled with CFR 0.152.
 */
package net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate;

import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.openid.connect.sdk.OIDCTokenResponse;
import java.text.ParseException;
import java.util.function.BiFunction;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.ThreadSafe;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.AccessTokenResponseContext;
import net.shibboleth.idp.plugin.authn.oidc.rp.context.navigate.AbstractTokenResponseLookupStrategy;
import net.shibboleth.shared.annotation.ParameterName;
import net.shibboleth.shared.primitive.LoggerFactory;
import org.opensaml.profile.context.ProfileRequestContext;
import org.slf4j.Logger;

@ThreadSafe
public class SubFromIDTokenLookupFunction
extends AbstractTokenResponseLookupStrategy
implements BiFunction<ProfileRequestContext, JWTClaimsSet, String> {
    @Nonnull
    private final Logger log = LoggerFactory.getLogger(SubFromIDTokenLookupFunction.class);

    public SubFromIDTokenLookupFunction() {
    }

    public SubFromIDTokenLookupFunction(@Nonnull @ParameterName(name="accessTokenContextLookupStrategy") Function<ProfileRequestContext, AccessTokenResponseContext> strategy) {
        super(strategy);
    }

    @Override
    @Nullable
    public String apply(@Nullable ProfileRequestContext prc, @Nullable JWTClaimsSet claimsSet) {
        OIDCTokenResponse tokenResponse;
        AccessTokenResponseContext tokenContext = this.getTokenResponseContextLookupStrategy().apply(prc);
        OIDCTokenResponse oIDCTokenResponse = tokenResponse = tokenContext != null ? tokenContext.getTokenResponse() : null;
        if (tokenResponse == null || tokenResponse.getOIDCTokens().getIDToken() == null) {
            return null;
        }
        try {
            JWTClaimsSet claims = tokenResponse.getOIDCTokens().getIDToken().getJWTClaimsSet();
            if (claims != null && claims.getSubject() != null) {
                return claims.getSubject();
            }
        }
        catch (ParseException e) {
            this.log.warn("Unable to parse id_token claims, can not extract subject", (Throwable)e);
        }
        return null;
    }
}

